/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.references.TypeReference;

public class NamespaceReference
extends TypeReference {
    public static final char NAMESPACE_SEPARATOR = '\\';
    public static final String NAMESPACE_DELIMITER = "\\";
    public static final String EMPTY = "";
    private boolean global;
    private boolean local;

    public NamespaceReference(int start, int end, String name) {
        super(start, end, name);
    }

    public NamespaceReference(int start, int end, String name, boolean global, boolean local) {
        super(start, end, name);
        this.global = global;
        this.local = local;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    @NonNull
    public String getName() {
        StringBuilder buf = new StringBuilder();
        if (this.global) {
            buf.append('\\');
        }
        if (this.local) {
            buf.append("namespace\\");
        }
        buf.append(super.getName());
        String name = buf.toString();
        assert (name.length() > 0);
        return name;
    }
}

