/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

public class OSGiLogHandler
implements OMLogHandler {
    public static final OSGiLogHandler INSTANCE = new OSGiLogHandler();

    protected OSGiLogHandler() {
    }

    @Override
    public void logged(OMLogger logger, OMLogger.Level level, String msg, Throwable t) {
        try {
            BundleContext bundleContext = ((OSGiBundle)logger.getBundle()).getBundleContext();
            this.logged(bundleContext, level, msg, t);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void logged(BundleContext bundleContext, OMLogger.Level level, String msg, Throwable t) {
        Logger logger = this.getLogger(bundleContext);
        switch (level) {
            case ERROR: {
                logger.error(msg, (Object)t);
                break;
            }
            case WARN: {
                logger.warn(msg, (Object)t);
                break;
            }
            case INFO: {
                logger.info(msg, (Object)t);
                break;
            }
            case DEBUG: {
                logger.debug(msg, (Object)t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal log level: " + (Object)((Object)level));
            }
        }
    }

    protected Logger getLogger(BundleContext bundleContext) {
        try {
            ServiceReference ref = bundleContext.getServiceReference(LoggerFactory.class.getName());
            LoggerFactory loggerFactory = (LoggerFactory)bundleContext.getService(ref);
            Bundle bundle = bundleContext.getBundle();
            return loggerFactory.getLogger(bundle, bundle.getSymbolicName(), Logger.class);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Logger service not found", ex);
        }
    }

    public static LogLevel toOSGi(OMLogger.Level level) {
        switch (level) {
            case ERROR: {
                return LogLevel.ERROR;
            }
            case WARN: {
                return LogLevel.WARN;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case DEBUG: {
                return LogLevel.DEBUG;
            }
        }
        throw new IllegalArgumentException("Illegal log level: " + (Object)((Object)level));
    }
}

