/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.internal.interpreter.DefaultConverter;

public class EvaluationResult
implements IEvaluationResult {
    private final Optional<Object> rawValue;
    private final IConverter converter;
    private final Diagnostic diagnostic;

    protected EvaluationResult(Optional<Object> rawValue, IConverter converter, Diagnostic diagnostic) {
        this.rawValue = rawValue;
        this.converter = converter;
        this.diagnostic = diagnostic;
    }

    public static IEvaluationResult ofValue(Object rawValue) {
        return EvaluationResult.ofValue(rawValue, new DefaultConverter(), Diagnostic.OK_INSTANCE);
    }

    public static IEvaluationResult ofValue(Object rawValue, IConverter converter) {
        return EvaluationResult.ofValue(rawValue, converter, Diagnostic.OK_INSTANCE);
    }

    public static IEvaluationResult ofValue(Object rawValue, IConverter converter, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() >= 4) {
            throw new IllegalArgumentException("An evalution can not produce a meaningful value if it was in error");
        }
        return new EvaluationResult(Optional.ofNullable(rawValue), converter, diagnostic);
    }

    public static IEvaluationResult ofError(Diagnostic error) {
        return new EvaluationResult(Optional.empty(), new FailedEvaluationConverter(), error);
    }

    public static IEvaluationResult ofError(Throwable th) {
        BasicDiagnostic diag = new BasicDiagnostic(4, "org.eclipse.sirius.common", 0, Messages.Interpreter_evaluationError, new Object[]{th});
        return EvaluationResult.ofError((Diagnostic)diag);
    }

    @Override
    public Object getValue() {
        return this.rawValue.orElse(null);
    }

    @Override
    public Optional<Collection<EObject>> asEObjects() {
        return this.rawValue.flatMap(this.converter::toEObjectCollection);
    }

    @Override
    public Optional<String> asString() {
        return this.rawValue.flatMap(this.converter::toString);
    }

    @Override
    public OptionalInt asInt() {
        if (this.rawValue.isPresent()) {
            return this.converter.toInt(this.rawValue.get());
        }
        return OptionalInt.empty();
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return this.rawValue.flatMap(this.converter::toBoolean);
    }

    @Override
    public Optional<EObject> asEObject() {
        return this.rawValue.flatMap(this.converter::toEObject);
    }

    @Override
    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    public boolean success() {
        return this.diagnostic.getSeverity() < 4;
    }

    public String toString() {
        if (this.success()) {
            return String.valueOf(this.getValue());
        }
        return this.diagnostic.toString();
    }

    private static final class FailedEvaluationConverter
    implements IConverter {
        private FailedEvaluationConverter() {
        }

        @Override
        public Optional<String> toString(Object rawValue) {
            return Optional.empty();
        }

        @Override
        public OptionalInt toInt(Object rawValue) {
            return OptionalInt.empty();
        }

        @Override
        public Optional<Collection<EObject>> toEObjectCollection(Object rawValue) {
            return Optional.empty();
        }

        @Override
        public Optional<EObject> toEObject(Object rawValue) {
            return Optional.empty();
        }

        @Override
        public Optional<Boolean> toBoolean(Object rawValue) {
            return Optional.empty();
        }
    }
}

