/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;

public abstract class DirectEditPolicy
extends GraphicalEditPolicy {
    private boolean showing;

    @Override
    public void eraseSourceFeedback(Request request) {
        if ("direct edit" == request.getType()) {
            this.eraseDirectEditFeedback((DirectEditRequest)request);
        }
    }

    protected void eraseDirectEditFeedback(DirectEditRequest request) {
        if (this.showing) {
            this.revertOldEditValue(request);
            this.showing = false;
        }
    }

    @Override
    public Command getCommand(Request request) {
        if ("direct edit" == request.getType()) {
            return this.getDirectEditCommand((DirectEditRequest)request);
        }
        return null;
    }

    protected abstract Command getDirectEditCommand(DirectEditRequest var1);

    protected void revertOldEditValue(DirectEditRequest request) {
        this.getHost().refresh();
    }

    @Override
    public void showSourceFeedback(Request request) {
        if ("direct edit" == request.getType()) {
            this.showDirectEditFeedback((DirectEditRequest)request);
        }
    }

    protected void showDirectEditFeedback(DirectEditRequest request) {
        if (!this.showing) {
            this.storeOldEditValue(request);
            this.showing = true;
        }
        this.showCurrentEditValue(request);
    }

    protected abstract void showCurrentEditValue(DirectEditRequest var1);

    protected void storeOldEditValue(DirectEditRequest request) {
    }

    @Override
    public boolean understandsRequest(Request request) {
        if ("direct edit".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

