/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.dialogs.cpd.TreeManager;

class FilteredTreeCheckProvider
implements ICheckStateProvider {
    private final ITreeContentProvider contentProvider;
    private final ViewerFilter filter;

    public FilteredTreeCheckProvider(ITreeContentProvider contentProvider, ViewerFilter filter) {
        this.contentProvider = contentProvider;
        this.filter = filter;
    }

    public boolean isChecked(Object element) {
        TreeManager.TreeItem treeItem = (TreeManager.TreeItem)element;
        return FilteredTreeCheckProvider.getLeafStates(treeItem, this.contentProvider, this.filter) != 0;
    }

    public boolean isGrayed(Object element) {
        TreeManager.TreeItem treeItem = (TreeManager.TreeItem)element;
        return FilteredTreeCheckProvider.getLeafStates(treeItem, this.contentProvider, this.filter) == 1;
    }

    static int getLeafStates(TreeManager.TreeItem item, ITreeContentProvider provider, ViewerFilter filter) {
        Object[] children = provider.getChildren((Object)item);
        boolean checkedFound = false;
        boolean uncheckedFound = false;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (filter.select(null, null, element)) {
                TreeManager.TreeItem child = (TreeManager.TreeItem)element;
                switch (FilteredTreeCheckProvider.getLeafStates(child, provider, filter)) {
                    case 2: {
                        checkedFound = true;
                        break;
                    }
                    case 1: {
                        uncheckedFound = true;
                        checkedFound = true;
                        break;
                    }
                    case 0: {
                        uncheckedFound = true;
                    }
                }
                if (checkedFound && uncheckedFound) {
                    return 1;
                }
            }
            ++n2;
        }
        if (!checkedFound && !uncheckedFound) {
            return item.getState() ? 2 : 0;
        }
        return checkedFound ? 2 : 0;
    }
}

