/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;

public class SelectionHelper {
    public static Region getRegion(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection txtSelection = (ITextSelection)selection;
            return new Region(txtSelection.getOffset(), txtSelection.getLength());
        }
        return null;
    }

    public static IASTSimpleDeclaration findFirstSelectedDeclaration(final IRegion textSelection, IASTTranslationUnit translationUnit) {
        final Container container = new Container();
        translationUnit.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof IASTSimpleDeclaration && SelectionHelper.doesNodeOverlapWithRegion((IASTNode)declaration, textSelection)) {
                    container.setObject((IASTSimpleDeclaration)declaration);
                }
                return super.visit(declaration);
            }
        });
        return (IASTSimpleDeclaration)container.getObject();
    }

    public static boolean doesNodeOverlapWithRegion(IASTNode node, IRegion region) {
        return SelectionHelper.doRegionsOverlap(SelectionHelper.getNodeSpan(node), region);
    }

    public static boolean isNodeInsideRegion(IASTNode node, IRegion region) {
        return SelectionHelper.isRegionInside(SelectionHelper.getNodeSpan(node), region);
    }

    private static boolean isRegionInside(IRegion region1, IRegion region2) {
        int offset2;
        int offset1 = region1.getOffset();
        return offset1 >= (offset2 = region2.getOffset()) && offset1 + region1.getLength() <= offset2 + region2.getLength();
    }

    private static boolean doRegionsOverlap(IRegion region1, IRegion region2) {
        int offset1 = region1.getOffset();
        int offset2 = region2.getOffset();
        return offset1 + region1.getLength() >= offset2 && offset1 <= offset2 + region2.getLength();
    }

    public static boolean isNodeInsideSelection(IASTNode node, IRegion selection) {
        return node.isPartOfTranslationUnitFile() && SelectionHelper.isNodeInsideRegion(node, selection);
    }

    public static boolean isSelectionInsideNode(IASTNode node, IRegion selection) {
        return node.isPartOfTranslationUnitFile() && SelectionHelper.isRegionInside(selection, SelectionHelper.getNodeSpan(node));
    }

    public static boolean nodeMatchesSelection(IASTNode node, IRegion region) {
        return SelectionHelper.getNodeSpan(node).equals(region);
    }

    protected static IRegion getNodeSpan(IASTNode region) {
        int start = Integer.MAX_VALUE;
        int nodeLength = 0;
        IASTNodeLocation[] nodeLocations = region.getNodeLocations();
        if (nodeLocations.length != 1) {
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    if (nodeOffset < start) {
                        start = nodeOffset;
                    }
                    nodeLength += macroLoc.asFileLocation().getNodeLength();
                } else {
                    IASTFileLocation loc = region.getFileLocation();
                    nodeOffset = loc.getNodeOffset();
                    if (nodeOffset < start) {
                        start = nodeOffset;
                    }
                    nodeLength = loc.getNodeLength();
                }
                ++n2;
            }
        } else if (nodeLocations[0] instanceof IASTMacroExpansionLocation) {
            IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)nodeLocations[0];
            start = macroLoc.asFileLocation().getNodeOffset();
            nodeLength = macroLoc.asFileLocation().getNodeLength();
        } else {
            IASTFileLocation loc = region.getFileLocation();
            start = loc.getNodeOffset();
            nodeLength = loc.getNodeLength();
        }
        return new Region(start, nodeLength);
    }
}

