/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.templateengine;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddMakeTarget
extends ProcessRunner {
    private static final String BUILDER_ID = "org.eclipse.cdt.build.MakeTargetBuilder";
    private static final String PROJECTNAME_VARNAME = "projectName";
    private static final String TARGETNAME_VARNAME = "targetName";
    private static final String MAKETARGET_VARNAME = "makeTarget";
    private static final String BUILDCOMMAND_VARNAME = "buildCommand";
    private static final String BUILDARGUMENTS_COMMAND_VARNAME = "buildArguments";
    private static final String BUILDCOMMAND_DEFAULT = "make";
    private static final String BUILDARGUMENTS_DEFAULT = "";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject project = null;
        String targetName = null;
        String makeTarget = null;
        String buildCommand = null;
        String buildArguments = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (PROJECTNAME_VARNAME.equals(argName)) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (TARGETNAME_VARNAME.equals(argName)) {
                targetName = arg.getSimpleValue();
            } else if (MAKETARGET_VARNAME.equals(argName)) {
                makeTarget = arg.getSimpleValue();
            } else if (BUILDCOMMAND_VARNAME.equals(argName)) {
                buildCommand = arg.getSimpleValue();
            } else if (BUILDARGUMENTS_COMMAND_VARNAME.equals(argName)) {
                buildArguments = arg.getSimpleValue();
            }
            ++n2;
        }
        if (project == null) {
            throw this.missingArgException(processId, PROJECTNAME_VARNAME);
        }
        if (targetName == null) {
            throw this.missingArgException(processId, TARGETNAME_VARNAME);
        }
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        try {
            IMakeTarget target = makeTargetManager.createTarget(project, targetName, BUILDER_ID);
            target.setBuildAttribute(IMakeTarget.BUILD_TARGET, makeTarget == null ? targetName : makeTarget);
            target.setUseDefaultBuildCmd(buildCommand == null);
            target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, buildCommand == null ? BUILDCOMMAND_DEFAULT : buildCommand);
            target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, buildArguments == null ? BUILDARGUMENTS_DEFAULT : buildArguments);
            makeTargetManager.addTarget(target);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }
}

