/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.ClasspathContainerState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;

public class RequiredPluginsInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        IProject project = javaProject.getProject();
        IClasspathContainer savedState = ClasspathContainerState.readState(project);
        if (PDECore.DEBUG_STATE && !Thread.currentThread().getName().contains("Initializing Java Tooling")) {
            PDECore.TRACE.traceDumpStack("/debug/state");
        }
        ClasspathContainerState.setProjectContainers(new IJavaProject[]{javaProject}, new IClasspathContainer[]{savedState}, null);
        ClasspathContainerState.requestClasspathUpdate(project, savedState);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null || project == null) {
            return null;
        }
        return containerPath.segment(0) + "/" + project.getPath().segment(0);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IStatus getSourceAttachmentStatus(IPath containerPath, IJavaProject project) {
        return Status.OK_STATUS;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }
}

