/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.deployables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.internal.deployables.JEEFlexProjDeployable;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.server.core.EJBBean;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.NullModuleArtifact;

public class EJBDeployableArtifactAdapterUtil {
    public static IModuleArtifact getModuleObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EJBJar) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((EJBJar)obj);
        }
        if (obj instanceof SessionBean) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((SessionBean)obj);
        }
        if (obj instanceof MessageDrivenBean) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((MessageDrivenBean)obj);
        }
        if (obj instanceof EntityBean) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((EntityBean)obj);
        }
        if (obj instanceof IProject) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((IProject)obj);
        }
        if (obj instanceof IJavaProject) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject(((IJavaProject)obj).getProject());
        }
        if (obj instanceof IFile) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((IFile)obj);
        }
        if (obj instanceof ICompilationUnit) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((ICompilationUnit)obj);
        }
        return null;
    }

    protected static boolean hasInterestedComponents(IProject project) {
        return JavaEEProjectUtilities.isEJBProject((IProject)project);
    }

    protected static IModuleArtifact getModuleObject(ICompilationUnit cu) {
        try {
            IFile file = (IFile)cu.getCorrespondingResource();
            IProject project = file.getProject();
            if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(project)) {
                return EJBDeployableArtifactAdapterUtil.getModuleJavaObject(file);
            }
        }
        catch (JavaModelException e) {
            JEEUIPlugin.logError((CoreException)e);
        }
        return null;
    }

    protected static IModuleArtifact getModuleObject(EJBJar ejbJar) {
        IModule dep = EJBDeployableArtifactAdapterUtil.getModule((EObject)ejbJar);
        return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, null, false, false);
    }

    protected static IModuleArtifact getModuleObject(SessionBean ejb) {
        IModule dep = EJBDeployableArtifactAdapterUtil.getModule((EObject)ejb);
        return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, ejb.getEjbName(), false, false);
    }

    protected static IModuleArtifact getModuleObject(EntityBean ejb) {
        IModule dep = EJBDeployableArtifactAdapterUtil.getModule((EObject)ejb);
        return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, ejb.getEjbName(), false, false);
    }

    protected static IModuleArtifact getModuleObject(MessageDrivenBean ejb) {
        IModule dep = EJBDeployableArtifactAdapterUtil.getModule((EObject)ejb);
        return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, ejb.getEjbName(), false, false);
    }

    protected static IModuleArtifact[] getModuleObjects(SessionBean ejb) {
        ArrayList<IModuleArtifact> modArtifacts = new ArrayList<IModuleArtifact>();
        IModule dep = EJBDeployableArtifactAdapterUtil.getModule((EObject)ejb);
        List busLocals = ejb.getBusinessLocals();
        List busRemotes = ejb.getBusinessRemotes();
        for (String localName : busLocals) {
            modArtifacts.add(EJBDeployableArtifactAdapterUtil.createModuleObjectForSessionBean(dep, ejb.getEjbName(), localName, false, true));
        }
        for (String remoteName : busRemotes) {
            modArtifacts.add(EJBDeployableArtifactAdapterUtil.createModuleObjectForSessionBean(dep, ejb.getEjbName(), remoteName, true, false));
        }
        if (ejb.getLocalBean() != null) {
            modArtifacts.add(EJBDeployableArtifactAdapterUtil.createModuleObjectForSessionBean(dep, ejb.getEjbName(), ejb.getEjbClass(), false, false));
        }
        return modArtifacts.toArray(new IModuleArtifact[modArtifacts.size()]);
    }

    protected static IModuleArtifact getModuleObject(IProject project) {
        if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(project)) {
            IModule dep = EJBDeployableArtifactAdapterUtil.getModule(project, null);
            return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, null, false, false);
        }
        return null;
    }

    protected static IModuleArtifact getModuleObject(IFile file) {
        IVirtualResource[] resources = ComponentCore.createResources((IResource)file);
        IVirtualComponent component = null;
        if (resources[0] != null || resources.length <= 0) {
            component = resources[0].getComponent();
        }
        if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(file.getProject())) {
            String ext = file.getFileExtension();
            if ("java".equals(ext) || "class".equals(ext)) {
                return EJBDeployableArtifactAdapterUtil.getModuleJavaObject(file);
            }
            if (file.getProjectRelativePath().toString().endsWith("META-INF/ejb-jar.xml")) {
                return EJBDeployableArtifactAdapterUtil.createModuleObject(EJBDeployableArtifactAdapterUtil.getModule(file.getProject(), component), null, false, false);
            }
        }
        return null;
    }

    protected static IModule getModule(EObject refObject) {
        IProject proj = ProjectUtilities.getProject((EObject)refObject);
        if (proj == null) {
            return null;
        }
        Resource refResource = refObject.eResource();
        IVirtualResource[] resources = null;
        IVirtualComponent component = null;
        try {
            IFile eclipeServResoruce = WorkbenchResourceHelper.getFile((Resource)refResource);
            resources = ComponentCore.createResources((IResource)eclipeServResoruce);
            if (resources[0] != null) {
                component = resources[0].getComponent();
            }
        }
        catch (Exception e) {
            JEEUIPlugin.logError(e);
        }
        return EJBDeployableArtifactAdapterUtil.getModule(proj, component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static IModule getModule(IProject project, IVirtualComponent component) {
        IModule deployable = null;
        Iterator<IModule> iterator = Arrays.asList(ServerUtil.getModules((String)"jst.ejb")).iterator();
        String componentName = null;
        if (component == null) return EJBDeployableArtifactAdapterUtil.getModuleProject(project, iterator);
        componentName = component.getName();
        while (iterator.hasNext()) {
            IModule next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = next).getName().equals(componentName)) continue;
            return deployable;
        }
        return null;
    }

    protected static IModule getModuleProject(IProject project, Iterator iterator) {
        IModule deployable = null;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = (IModule)next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }

    protected static IModuleArtifact getModuleJavaObject(IFile file) {
        return null;
    }

    protected static IModuleArtifact createModuleObject(IModule module, String ejbName, boolean remote, boolean local) {
        if (module != null) {
            String jndiName = null;
            if (ejbName != null) {
                module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                JEEFlexProjDeployable moduleDelegate = (JEEFlexProjDeployable)module.getAdapter(ModuleDelegate.class);
                jndiName = moduleDelegate.getJNDIName(ejbName);
                return new EJBBean(module, jndiName, remote, local, "3.0");
            }
            return new NullModuleArtifact(module);
        }
        return null;
    }

    protected static IModuleArtifact createModuleObjectForSessionBean(IModule module, String ejbName, String interfaceName, boolean remote, boolean local) {
        if (module != null) {
            String jndiName = null;
            if (ejbName != null) {
                module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                JEEFlexProjDeployable moduleDelegate = (JEEFlexProjDeployable)module.getAdapter(ModuleDelegate.class);
                jndiName = moduleDelegate.getJNDIName(ejbName, interfaceName);
                return new EJBBean(module, jndiName, remote, local, "3.0", interfaceName);
            }
            return new NullModuleArtifact(module);
        }
        return null;
    }
}

