/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.UIComponentService;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.sql.ui.dialogs.SQLPainterDlg;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class DMLDialogSelectionSQLAction
extends Action
implements ISelectionChangedListener,
IPageUpdate,
IUpdate {
    private SQLEditor _sqlEditor;
    private ITextSelection _selection;
    private boolean _isSourcePage = true;

    public DMLDialogSelectionSQLAction(SQLEditor targetEditor) {
        this.setText(Messages.DMLDialogSelectionSQLAction_label);
        this.setToolTipText(Messages.DMLDialogSelectionSQLAction_tooltip);
        this.setImageDescriptor(SQLEditorResources.getImageDescriptor("sql_execute_selection"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction");
        this.setId("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"execute_selected_text_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void run() {
        SQLDevToolsUIConfiguration conf = SQLToolsUIFacade.getConfigurationByProfileName((String)this._sqlEditor.getConnectionInfo().getConnectionProfileName());
        UIComponentService componentService = conf.getUIComponentService();
        if (componentService.supportsDMLDialog()) {
            SQLPainterDlg dlg;
            String sql;
            HashMap<String, IFile> map = new HashMap<String, IFile>();
            if (this.getFile() != null) {
                map.put("file", this.getFile());
            }
            if ((sql = (dlg = componentService.getDMLDialog(this._sqlEditor.getSite().getShell(), null, this.getSQLStatements(), this._sqlEditor.getConnectionInfo().getConnectionProfileName(), null, null, null, null, map)).load()) != null) {
                this._sqlEditor.insert(sql);
            }
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this._sqlEditor);
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.isConnected());
    }

    public String getSQLStatements() {
        return this._sqlEditor == null ? null : SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(this._sqlEditor.getSelectedText());
    }

    public IFile getFile() {
        IFile file = null;
        if (this._sqlEditor != null) {
            IEditorInput input = this._sqlEditor.getEditorInput();
            file = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        }
        return file;
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)DMLDialogSelectionSQLAction.this._sqlEditor);
            }
        };
        return postRun;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this._selection = (ITextSelection)event.getSelection();
            this.update();
        }
    }

    protected boolean promptVariable() {
        return true;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlEditor != null) {
            String profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileName();
            String dbName = this._sqlEditor.getConnectionInfo().getDatabaseName();
            return new DatabaseIdentifier(profileName, dbName);
        }
        return null;
    }

    @Override
    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

