/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.statesystem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.provider.StateSystemDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.Messages;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.StateSystemPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class TmfStateSystemExplorer
extends BaseDataProviderTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ssvisualizer";
    private static final String[] COLUMN_NAMES = new String[]{Messages.TreeNodeColumnLabel, Messages.QuarkColumnLabel};
    private final Set<ITmfAnalysisModuleWithStateSystems> fStartedAnalysis = ConcurrentHashMap.newKeySet();
    private static final Comparator<ITimeGraphEntry> NAME_COMPARATOR = (a, b) -> {
        if (a instanceof TimeGraphEntry && b instanceof TimeGraphEntry) {
            ITmfTreeDataModel aModel = ((TimeGraphEntry)a).getEntryModel();
            ITmfTreeDataModel bModel = ((TimeGraphEntry)b).getEntryModel();
            if (aModel instanceof StateSystemDataProvider.TraceEntryModel && bModel instanceof StateSystemDataProvider.TraceEntryModel) {
                ITmfTrace ta = ((StateSystemDataProvider.TraceEntryModel)aModel).getTrace();
                ITmfTrace tb = ((StateSystemDataProvider.TraceEntryModel)bModel).getTrace();
                if (ta instanceof TmfExperiment && !(tb instanceof TmfExperiment)) {
                    return -1;
                }
                if (!(ta instanceof TmfExperiment) && tb instanceof TmfExperiment) {
                    return 1;
                }
            }
        }
        try {
            return Long.compare(Long.parseLong(a.getName()), Long.parseLong(b.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            return a.getName().compareTo(b.getName());
        }
    };
    private static final Comparator<ITimeGraphEntry> QUARK_COMPARATOR = (a, b) -> {
        if (a instanceof TimeGraphEntry && b instanceof TimeGraphEntry) {
            ITmfTreeDataModel aModel = ((TimeGraphEntry)a).getEntryModel();
            ITmfTreeDataModel bModel = ((TimeGraphEntry)b).getEntryModel();
            if (aModel instanceof StateSystemDataProvider.AttributeEntryModel && bModel instanceof StateSystemDataProvider.AttributeEntryModel) {
                return Integer.compare(((StateSystemDataProvider.AttributeEntryModel)aModel).getQuark(), ((StateSystemDataProvider.AttributeEntryModel)bModel).getQuark());
            }
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry>[] COLUMN_COMPARATORS;
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int DEFAULT_AUTOEXPAND = 2;

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(NAME_COMPARATOR).add(QUARK_COMPARATOR);
        ImmutableList l = builder.build();
        COLUMN_COMPARATORS = l.toArray(new Comparator[l.size()]);
    }

    public TmfStateSystemExplorer() {
        super(ID, new StateSystemPresentationProvider(), "org.eclipse.tracecompass.internal.tmf.core.statesystem.provider.StateSystemDataProvider");
        this.setTreeColumns(COLUMN_NAMES, COLUMN_COMPARATORS, 0);
        this.setTreeLabelProvider(new StateSystemTreeLabelProvider());
        this.setAutoExpandLevel(2);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(event -> this.synchingToTime(event.getBeginTime()));
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ITimeGraphEntry selection = TmfStateSystemExplorer.this.getTimeGraphViewer().getSelection();
                if (selection instanceof TimeGraphEntry) {
                    boolean expandedState;
                    TimeGraphControl control;
                    ITmfTreeDataModel model = ((TimeGraphEntry)selection).getEntryModel();
                    if (model instanceof StateSystemDataProvider.ModuleEntryModel && selection.getChildren().isEmpty()) {
                        ITmfAnalysisModuleWithStateSystems module = ((StateSystemDataProvider.ModuleEntryModel)model).getModule();
                        module.schedule();
                    }
                    control.setExpandedState(selection, !(expandedState = (control = TmfStateSystemExplorer.this.getTimeGraphViewer().getTimeGraphControl()).getExpandedState(selection)));
                }
            }
        });
    }

    static ITmfStateSystem getStateSystem(TimeGraphEntry entry) {
        TimeGraphEntry parent = entry;
        while (parent != null) {
            if (!((parent = parent.getParent()).getEntryModel() instanceof StateSystemDataProvider.StateSystemEntryModel)) continue;
            return ((StateSystemDataProvider.StateSystemEntryModel)parent.getEntryModel()).getStateSystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void handleAnalysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule module = signal.getAnalysisModule();
        if (module instanceof ITmfAnalysisModuleWithStateSystems && !module.isAutomatic()) {
            ITmfTrace viewTrace = this.getTrace();
            if (Iterables.contains(TmfStateSystemExplorer.allModules(viewTrace), (Object)module)) {
                new Thread(() -> {
                    Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
                    synchronized (set) {
                        ITmfTrace moduleTrace;
                        this.fStartedAnalysis.add((ITmfAnalysisModuleWithStateSystems)module);
                        ITmfTrace iTmfTrace2 = moduleTrace = module instanceof TmfAbstractAnalysisModule ? ((TmfAbstractAnalysisModule)module).getTrace() : viewTrace;
                        if (moduleTrace != null) {
                            this.getDataProvider(moduleTrace).startedAnalysisSignalHandler((ITmfAnalysisModuleWithStateSystems)module);
                            this.rebuild();
                        }
                    }
                }).start();
            } else {
                for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
                    if (!Iterables.contains(TmfStateSystemExplorer.allModules(trace), (Object)module)) continue;
                    Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
                    synchronized (set) {
                        this.fStartedAnalysis.add((ITmfAnalysisModuleWithStateSystems)module);
                        this.resetView(trace);
                        break;
                    }
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private StateSystemDataProvider getDataProvider(ITmfTrace moduleTrace) {
        @NonNull ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(Objects.requireNonNull(moduleTrace), this.getProviderId(), ITimeGraphDataProvider.class);
        if (dataProvider instanceof StateSystemDataProvider) {
            return (StateSystemDataProvider)dataProvider;
        }
        throw new IllegalArgumentException();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Iterable<ITmfAnalysisModuleWithStateSystems> allModules(ITmfTrace trace) {
        @NonNull Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace);
        Iterable allModules = Iterables.concat((Iterable)Iterables.transform((Iterable)traces, ITmfTrace::getAnalysisModules));
        return Iterables.filter((Iterable)allModules, ITmfAnalysisModuleWithStateSystems.class);
    }

    @Override
    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace);
    }

    @Override
    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        TimeEvent event = super.createTimeEvent(entry, state);
        if (event instanceof NullTimeEvent) {
            return new TimeEvent(entry, (ITimeElement)state);
        }
        return event;
    }

    private static class StateSystemTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private StateSystemTreeLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                entry.getParent();
                if (columnIndex == 0) {
                    return entry.getName();
                }
                if (entry.getEntryModel() instanceof StateSystemDataProvider.AttributeEntryModel) {
                    StateSystemDataProvider.AttributeEntryModel model = (StateSystemDataProvider.AttributeEntryModel)entry.getEntryModel();
                    if (columnIndex == 1) {
                        return Integer.toString(model.getQuark());
                    }
                }
            }
            return "";
        }
    }
}

