/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.closeable.AutoCloseableDelegateInvocationHandler;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioChannelDelegateInvocationHandler
extends AutoCloseableDelegateInvocationHandler {
    public NioChannelDelegateInvocationHandler(Object proxyTarget, Channel delegate) {
        super(proxyTarget, delegate);
    }

    public Channel getChannelDelegate() {
        return (Channel)Channel.class.cast(super.getAutoCloseableDelegate());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(method, args)) {
            return super.invoke(proxy, method, args);
        }
        Channel channelDelegate = this.getChannelDelegate();
        try {
            return method.invoke((Object)channelDelegate, args);
        }
        catch (Throwable t) {
            Class<?> targetType = channelDelegate.getClass();
            Logger log = LoggerFactory.getLogger(targetType);
            LoggingUtils.debug(log, "invoke({}#{}) failed ({}) to execute: {}", targetType.getSimpleName(), method.getName(), t.getClass().getSimpleName(), t.getMessage(), t);
            throw ProxyUtils.unwrapInvocationThrowable(t);
        }
    }

    public static <T extends Channel> T wrapDelegateChannel(Object proxyTarget, Class<T> type, Channel delegate) {
        return (T)((Channel)ProxyUtils.newProxyInstance(type, new NioChannelDelegateInvocationHandler(proxyTarget, delegate)));
    }

    public static boolean isQueryOpenMethodInvocation(Method m, Object[] args) {
        return NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(m) && GenericUtils.isEmpty(args);
    }

    public static boolean isQueryOpenMethodInvocation(Method m) {
        int mods = m == null ? 0 : m.getModifiers();
        return m != null && "isOpen".equals(m.getName()) && Modifier.isPublic(mods) && !Modifier.isStatic(mods) && Boolean.TYPE == m.getReturnType() && GenericUtils.isEmpty(m.getParameterTypes());
    }
}

