/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.actions.ProjectActionGroup;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.browsing.ProjectAndSourceFolderContentProvider;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingPart;
import org.eclipse.dltk.ui.viewsupport.FilterUpdater;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ProjectsView
extends ScriptBrowsingPart {
    private FilterUpdater fFilterUpdater;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer result = new ProblemTreeViewer(parent, 2);
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)result);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        return result;
    }

    @Override
    public void dispose() {
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        return super.getAdapter(key);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new ProjectAndSourceFolderContentProvider(this, this.getToolkit());
    }

    @Override
    protected String getHelpContextId() {
        return "";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.dltk.ui.browsing.projects.to.editor";
    }

    @Override
    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)ProjectsView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    @Override
    protected void setInitialInput() {
        IScriptModel root = DLTKCore.create((IWorkspaceRoot)DLTKUIPlugin.getWorkspace().getRoot());
        this.getViewer().setInput((Object)root);
        this.updateTitle();
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof IScriptModel;
    }

    @Override
    protected boolean isValidElement(Object element) {
        if (!(element instanceof IScriptProject) && !(element instanceof IProjectFragment)) {
            return false;
        }
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element));
        if (languageToolkit != null) {
            return languageToolkit.getNatureId().equals(this.getToolkit().getNatureId());
        }
        return false;
    }

    @Override
    protected IModelElement findElementToSelect(IModelElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 1: {
                return null;
            }
            case 2: {
                return je;
            }
            case 3: {
                if (je.getElementName().equals("")) {
                    return je.getParent();
                }
                return je;
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    @Override
    protected void setInput(Object input) {
        if (input != null) {
            super.setInput(input);
        } else {
            this.getViewer().setSelection(null);
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fActionGroups.addGroup(new ProjectActionGroup((IViewPart)this));
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object selectedElement : sel) {
                if (!(selectedElement instanceof LogicalPackage)) continue;
                selection = new StructuredSelection((Object)((LogicalPackage)((Object)selectedElement)).getScriptProject());
                break;
            }
        }
        super.selectionChanged(part, selection);
    }
}

