/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private ScriptEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Deprecated
    public OpenCallHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenCallHierarchyAction(ScriptEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IModelElement.class);
        }
        if (!(input instanceof IModelElement)) {
            return false;
        }
        switch (((IModelElement)input).getElementType()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    protected IModelElement[] resolveModelElements() throws InvocationTargetException, InterruptedException {
        return SelectionConverter.codeResolveOrInputForked((IEditorPart)this.fEditor);
    }

    @Override
    public void run(ITextSelection selection) {
        IModelElement input = SelectionConverter.getInput((IEditorPart)this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IModelElement enclosingMethod;
            IModelElement[] elements = this.resolveModelElements();
            if (elements == null) {
                return;
            }
            ArrayList<IModelElement> candidates = new ArrayList<IModelElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IModelElement[] resolvedElements = CallHierarchyUI.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod(input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            this.run(candidates.toArray(new IModelElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenCallHierarchyAction.getErrorDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IModelElement getEnclosingMethod(IModelElement input, ITextSelection selection) {
        IModelElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 5: {
                    ISourceModule cu = (ISourceModule)input.getAncestor(5);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 9) {
                return enclosingElement;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement)) {
            input = ((IAdaptable)input).getAdapter(IModelElement.class);
        }
        if (!(input instanceof IModelElement)) {
            IStatus status = OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_java_element);
            this.openErrorDialog(status);
            return;
        }
        IModelElement element = (IModelElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenCallHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IModelElement[result.size()]));
        } else {
            this.openErrorDialog(status);
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = CallHierarchyMessages.OpenCallHierarchyAction_messages_title;
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return CallHierarchyMessages.OpenCallHierarchyAction_dialog_title;
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open(elements, this.getSite().getWorkbenchWindow(), this.getCallHierarchyID());
    }

    private static IStatus compileCandidates(List result, IModelElement elem) {
        Status ok = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 9: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, DLTKUIPlugin.getPluginId(), 10001, message, null);
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }
}

