/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.SourceRange;

public class ModelElementUtil {
    private ModelElementUtil() {
    }

    public static IModelElement[] getElementsOfType(IModelElement[] elements, int type) {
        HashSet<IModelElement> result = new HashSet<IModelElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            if (element.getElementType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public static boolean isAncestorOf(IModelElement ancestor, IModelElement child) {
        IModelElement parent = child.getParent();
        while (parent != null && !parent.equals(ancestor)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public static IMethod[] getAllConstructors(IType type) throws ModelException {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod iMethod = methods[i];
            if (iMethod.isConstructor()) {
                result.add(iMethod);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IScriptProject[] getReferencingProjects(IProjectFragment root) throws ModelException {
        IBuildpathEntry cpe = root.getRawBuildpathEntry();
        IScriptProject myProject = root.getScriptProject();
        IScriptProject[] allScriptProjects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
        ArrayList<IScriptProject> result = new ArrayList<IScriptProject>(allScriptProjects.length);
        int i = 0;
        while (i < allScriptProjects.length) {
            IProjectFragment[] roots;
            IScriptProject project = allScriptProjects[i];
            if (!project.equals(myProject) && (roots = project.findProjectFragments(cpe)).length > 0) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IScriptProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        IMember member;
        ArrayList<IMember> result = new ArrayList<IMember>(a1.length + a2.length);
        int i = 0;
        while (i < a1.length) {
            member = a1[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            member = a2[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IScriptFolder && ((IScriptFolder)element).isRootFolder();
    }

    public static IScriptFolder[] getPackageAndSubpackages(IScriptFolder pack) throws ModelException {
        if (pack.isRootFolder()) {
            return new IScriptFolder[]{pack};
        }
        IProjectFragment root = (IProjectFragment)pack.getParent();
        IModelElement[] allPackages = root.getChildren();
        ArrayList<IScriptFolder> subpackages = new ArrayList<IScriptFolder>();
        subpackages.add(pack);
        IPath folderPath = pack.getPath();
        int i = 0;
        while (i < allPackages.length) {
            IScriptFolder currentPackage = (IScriptFolder)allPackages[i];
            IPath currentPackagePath = currentPackage.getPath();
            if (folderPath.isPrefixOf(currentPackagePath) && !folderPath.equals((Object)currentPackagePath)) {
                subpackages.add(currentPackage);
            }
            ++i;
        }
        return subpackages.toArray(new IScriptFolder[subpackages.size()]);
    }

    public static IScriptFolder getParentSubpackage(IScriptFolder pack) {
        String newPackageName;
        if (pack.isRootFolder()) {
            return null;
        }
        int index = pack.getElementName().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        IProjectFragment root = (IProjectFragment)pack.getParent();
        IScriptFolder parent = root.getScriptFolder(newPackageName = pack.getElementName().substring(0, index));
        if (parent.exists()) {
            return parent;
        }
        return null;
    }

    public static IMember[] sortByOffset(IMember[] members) {
        Comparator<IMember> comparator = new Comparator<IMember>(){

            @Override
            public int compare(IMember o1, IMember o2) {
                try {
                    return o1.getNameRange().getOffset() - o2.getNameRange().getOffset();
                }
                catch (ModelException modelException) {
                    return 0;
                }
            }
        };
        Arrays.sort(members, comparator);
        return members;
    }

    public static boolean isSourceAvailable(ISourceReference sourceReference) {
        try {
            return SourceRange.isAvailable((ISourceRange)sourceReference.getSourceRange());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public static String createFieldSignature(IField field) {
        return String.valueOf(ScriptModelUtil.getFullyQualifiedName((IType)field.getDeclaringType())) + '/' + field.getElementName();
    }
}

