/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.launching.IPathEquality;
import org.eclipse.dltk.internal.launching.PathEqualityUtils;
import org.eclipse.dltk.ruby.debug.RubyFilenameLinenumberResolver;
import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyFileHyperlink;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.RubyOpenEditorAction;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.testing.AbstractTestRunnerUI;
import org.eclipse.dltk.testing.ITestElementResolver;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class AbstractRubyTestRunnerUI
extends AbstractTestRunnerUI
implements ITestRunnerUI,
ITestElementResolver {
    protected static final Pattern STACK_FRAME_IN_PATTERN = Pattern.compile("(.+):(\\d+):in `(.+)'");
    protected static final Pattern STACK_FRAME_PATTERN = RubyFilenameLinenumberResolver.createPattern();
    protected final IScriptProject project;
    protected final AbstractRubyTestingEngine testingEngine;
    protected IPathEquality pathEquality;

    public AbstractRubyTestRunnerUI(AbstractRubyTestingEngine testingEngine, IScriptProject project) {
        this.testingEngine = testingEngine;
        this.project = project;
        this.pathEquality = PathEqualityUtils.getInstance();
    }

    public String getDisplayName() {
        return this.testingEngine.getName();
    }

    public boolean isStackFrame(String line) {
        return STACK_FRAME_IN_PATTERN.matcher(line).matches() || STACK_FRAME_PATTERN.matcher(line).matches();
    }

    public IAction createOpenEditorAction(String line) {
        Object element;
        Matcher matcher = STACK_FRAME_IN_PATTERN.matcher(line);
        if (!matcher.matches()) {
            matcher = STACK_FRAME_PATTERN.matcher(line);
        }
        if (matcher.matches() && (element = RubyFileHyperlink.findSourceModule((String)matcher.group(1))) != null) {
            int lineNumber;
            try {
                lineNumber = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new RubyOpenEditorAction(element, lineNumber);
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ITestElementResolver.class.equals(adapter)) {
            return (T)((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    protected final IDLTKSearchScope getSearchScope() {
        return SearchEngine.createSearchScope((IModelElement)this.project);
    }

    public TestElementResolution resolveElement(ITestElement element) {
        if (element instanceof ITestCaseElement) {
            return this.resolveTestCase((ITestCaseElement)element);
        }
        if (element instanceof ITestSuiteElement) {
            return this.resolveTestSuite((ITestSuiteElement)element);
        }
        return null;
    }

    protected abstract TestElementResolution resolveTestSuite(ITestSuiteElement var1);

    protected abstract TestElementResolution resolveTestCase(ITestCaseElement var1);

    protected IPreferenceStore getPreferenceStore() {
        return RubyTestingPlugin.getDefault().getPreferenceStore();
    }

    public boolean canFilterStack() {
        return true;
    }

    public String filterStackTrace(String trace) {
        BufferedReader reader = new BufferedReader(new StringReader(trace));
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printer = new PrintWriter(stringWriter);
            String line = reader.readLine();
            if (line != null) {
                printer.println(line);
                while ((line = reader.readLine()) != null) {
                    if (this.isStackFrame(line)) {
                        if (!this.selectLine(line)) continue;
                        printer.println(line);
                        continue;
                    }
                    printer.println(line);
                }
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return trace;
        }
    }

    protected boolean selectLine(String line) {
        return true;
    }

    protected String extractFileName(String line) {
        Matcher matcher = STACK_FRAME_PATTERN.matcher(line);
        boolean matches = matcher.matches();
        if (!matches) {
            matcher = STACK_FRAME_IN_PATTERN.matcher(line);
            matches = matcher.matches();
        }
        if (matches) {
            return matcher.group(1);
        }
        return null;
    }

    public ITestingEngine getTestingEngine() {
        return this.testingEngine;
    }

    public IScriptProject getProject() {
        return this.project;
    }
}

