/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.InterpreterContainer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterContainerInitializer
extends BuildpathContainerInitializer {
    public void initialize(IPath containerPath, IScriptProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
            IInterpreterInstall interp = InterpreterContainerInitializer.resolveInterpreter(InterpreterContainerInitializer.getNatureFromProject(project), InterpreterContainerInitializer.getEnvironmentFromProject(project), containerPath);
            InterpreterContainer container = null;
            if (interp != null) {
                container = new InterpreterContainer(interp, containerPath, project);
            }
            DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{project}, (IBuildpathContainer[])new IBuildpathContainer[]{container}, null);
        }
    }

    public static IInterpreterInstall resolveInterpreter(String natureId, String environment, IPath containerPath) throws CoreException {
        String typeId;
        IInterpreterInstallType installType;
        if (containerPath.segmentCount() > 1 && (installType = ScriptRuntime.getInterpreterInstallType(typeId = InterpreterContainerInitializer.getInterpreterTypeId(containerPath))) != null) {
            String name = InterpreterContainerInitializer.getInterpreterName(containerPath);
            return installType.findInterpreterInstallByName(name);
        }
        return ScriptRuntime.getDefaultInterpreterInstall(new ScriptRuntime.DefaultInterpreterEntry(natureId, environment));
    }

    public static String getInterpreterTypeId(IPath path) {
        return path.segment(1);
    }

    public static String getInterpreterName(IPath path) {
        return path.segment(2).replaceAll("%2F", "/");
    }

    public boolean canUpdateBuildpathContainer(IPath containerPath, IScriptProject project) {
        if (containerPath != null && containerPath.segmentCount() > 0 && ScriptRuntime.INTERPRETER_CONTAINER.equals(containerPath.segment(0))) {
            try {
                return InterpreterContainerInitializer.resolveInterpreter(InterpreterContainerInitializer.getNatureFromProject(project), InterpreterContainerInitializer.getEnvironmentFromProject(project), containerPath) != null;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    public static String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public static String getEnvironmentFromProject(IScriptProject project) {
        return EnvironmentManager.getEnvironmentId((IProject)project.getProject());
    }

    public void requestBuildpathContainerUpdate(IPath containerPath, IScriptProject project, IBuildpathContainer containerSuggestion) throws CoreException {
        IInterpreterInstall interpreter = InterpreterContainerInitializer.resolveInterpreter(InterpreterContainerInitializer.getNatureFromProject(project), InterpreterContainerInitializer.getEnvironmentFromProject(project), containerPath);
        if (interpreter == null) {
            Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 105, MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainerInitializer_InterpreterEnvironment_referenced_by_classpath_container__0__does_not_exist__1, (Object[])new Object[]{containerPath.toString()}), null);
            throw new CoreException((IStatus)status);
        }
        IBuildpathEntry[] entries = containerSuggestion.getBuildpathEntries();
        LibraryLocation[] libs = new LibraryLocation[entries.length];
        int i = 0;
        while (i < entries.length) {
            IPath path;
            IBuildpathEntry entry = entries[i];
            if (entry.getEntryKind() == 1) {
                path = entry.getPath();
                File lib = path.toFile();
                if (!lib.exists()) {
                    Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainerInitializer_Buildpath_entry__0__does_not_refer_to_an_existing_library__2, (Object[])new Object[]{entry.getPath().toString()}), null);
                    throw new CoreException((IStatus)status);
                }
            } else {
                Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainerInitializer_Buildpath_entry__0__does_not_refer_to_a_library__3, (Object[])new Object[]{entry.getPath().toString()}), null);
                throw new CoreException((IStatus)status);
            }
            libs[i] = new LibraryLocation(path);
            ++i;
        }
        InterpreterStandin standin = new InterpreterStandin(interpreter);
        standin.setLibraryLocations(libs);
        standin.convertToRealInterpreter();
        ScriptRuntime.saveInterpreterConfiguration();
    }

    public String getDescription(IPath containerPath, IScriptProject project) {
        String tag = null;
        if (containerPath.segmentCount() > 2) {
            tag = InterpreterContainerInitializer.getInterpreterName(containerPath);
        }
        if (tag != null) {
            return MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainer_InterpreterEnvironment_System_Library_1, (Object[])new Object[]{tag});
        }
        return LaunchingMessages.InterpreterEnvironmentContainerInitializer_Default_System_Library_1;
    }
}

