/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.List;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.browsing.IPackagesViewViewer;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class PackagesViewTreeViewer
extends ProblemTreeViewer
implements IPackagesViewViewer {
    public PackagesViewTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void mapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IScriptFolder[] fragments = cp.getScriptFolders();
            int i = 0;
            while (i < fragments.length) {
                IScriptFolder fragment = fragments[i];
                this.fResourceToItemsMapper.addToMap(fragment, (Item)item);
                ++i;
            }
        }
        super.mapElement(element, item);
    }

    public void unmapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IScriptFolder[] fragments = cp.getScriptFolders();
            int i = 0;
            while (i < fragments.length) {
                IScriptFolder fragment = fragments[i];
                this.fResourceToItemsMapper.removeFromMap(fragment, (Item)item);
                ++i;
            }
        }
        super.unmapElement(element, item);
    }

    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        boolean res = super.isFiltered(object, parent, filters);
        if (res && this.isEssential(object)) {
            return false;
        }
        return res;
    }

    private boolean isEssential(Object object) {
        try {
            LogicalPackage logicalPackage;
            if (object instanceof IScriptFolder) {
                IScriptFolder fragment = (IScriptFolder)object;
                if (!fragment.isRootFolder() && fragment.hasSubfolders()) {
                    return this.hasFilteredChildren(fragment);
                }
            } else if (object instanceof LogicalPackage && !(logicalPackage = (LogicalPackage)((Object)object)).isDefaultPackage() && logicalPackage.hasSubpackages()) {
                return !this.hasFilteredChildren(object);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return false;
    }

    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

