/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.javascript.internal.corext.codemanipulation.JSCodeGeneration;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptAutoEditStrategy;
import org.eclipse.dltk.ui.text.ScriptDefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class JSDocAutoIndentStrategy
extends ScriptDefaultIndentLineAutoEditStrategy {
    public JSDocAutoIndentStrategy(IPreferenceStore fPreferenceStore) {
        super(fPreferenceStore);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!command.doit) {
            return;
        }
        if (command.length == 0 && command.text != null) {
            if (this.isLineDelimiter(document, command.text)) {
                this.indentAfterNewLine(document, command);
            } else if (command.text.equals("/")) {
                this.indentAfterCommentEnd(document, command);
            }
        }
    }

    private boolean isCloseDocs() {
        return true;
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuilder buf = new StringBuilder(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" * ");
                if (this.isCloseDocs() && this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    int eolOffset = lineOffset + line.getLength();
                    int replacementLength = eolOffset - p;
                    String restOfLine = d.get(p, replacementLength);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    if (JSDocAutoIndentStrategy.isGenerateStub()) {
                        d.replace(offset, replacementLength, endTag);
                        IMethod method = JavascriptAutoEditStrategy.findMethod(d, offset - replacementLength + endTag.length(), true);
                        if (method != null) {
                            buf.append(restOfLine);
                            String string = JSCodeGeneration.getMethodComment(method, null, lineDelimiter);
                            if (string != null) {
                                string = JSDocAutoIndentStrategy.normalizeGeneratedDoc(string);
                                if ((string = JSCodeGeneration.changeIndent(string, 0, method.getScriptProject(), indentation, lineDelimiter)).length() != 0) {
                                    buf.append(string);
                                }
                            }
                        }
                    } else {
                        c.length = replacementLength;
                        buf.append(restOfLine);
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    static String normalizeGeneratedDoc(String string) {
        if ((string = string.trim()).startsWith("/**")) {
            string = string.substring("/**".length());
        }
        if (string.endsWith("*/")) {
            string = string.substring(0, string.length() - "*/".length());
        }
        if ((string = string.trim()).startsWith("*")) {
            string = string.substring(1).trim();
        }
        return string;
    }

    static boolean isGenerateStub() {
        return true;
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)"__javascript_partitioning", (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf("/*", 2) != -1;
    }

    private void indentAfterCommentEnd(IDocument document, DocumentCommand command) {
        if (command.offset < 2 || document.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(document.get(command.offset - 2, 2))) {
                ++command.length;
                --command.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

