/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValue;
import org.eclipse.dltk.internal.javascript.ti.Value;

public class ValueWithElementValue
extends Value {
    private final ElementValue elementValue;

    public ValueWithElementValue(ImmutableValue value, ElementValue elementValue) {
        this.elementValue = elementValue;
        if (value.attributes != null) {
            this.attributes = new HashMap<String, Object>(value.attributes);
        }
        this.children.putAll(value.children);
        this.declaredType = value.declaredType;
        if (value.deletedChildren != null) {
            this.deletedChildren = new HashSet<String>(value.deletedChildren);
        }
        this.inherited.putAll(value.inherited);
        this.kind = value.kind;
        this.location = value.location;
        this.references.addAll(value.references);
        this.types.addAll(value.types);
    }

    public Object getAttribute(String key, boolean includeReferences) {
        Object attribute = this.elementValue.getAttribute(key, includeReferences);
        if (attribute == null) {
            attribute = super.getAttribute(key, includeReferences);
        }
        return attribute;
    }

    public IValue getChild(String name, boolean resolve) {
        IValue child = this.elementValue.getChild(name, resolve);
        if (child == null) {
            child = super.getChild(name, resolve);
        }
        return child;
    }
}

