/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.chains;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.annotations.TaskChainMenuEntry;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.ui.annotations.TaskChainUiInit;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.TaskGenFeatureFromLcDsl;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.model.WorkspaceData;
import org.eclipse.tea.library.build.tasks.jar.TaskRunFeaturePluginJarExport;
import org.eclipse.tea.library.build.tasks.p2.TaskPublishFeatureUpdateSite;
import org.eclipse.tea.library.build.tasks.p2.TaskUpdateStrictFeatureVersions;
import org.eclipse.tea.library.build.ui.SelectProjectDialog;
import org.osgi.service.component.annotations.Component;

@TaskChainMenuEntry(icon="icons/site_obj.png", path={"TEA Build Library"}, groupingId="tea.misc.group")
@TaskChain.TaskChainId(description="Create Update Site from Feature...")
@Component
public class TaskChainBuildAnyFeatureSite
implements TaskChain {
    private static final String KEY_FEATURE = "feature_to_export";
    private static final String KEY_SITE_NAME = "feature_site_name";
    private static final String KEY_STRICT = "feature_strict_versions";

    @TaskChainUiInit
    public void selectFeature(IEclipseContext context, Shell parentShell, WorkspaceBuild wb) {
        SelectProjectDialog dlg = new SelectProjectDialog(parentShell, "Select feature to export", "Select a feature that should be exported", true, new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return WorkspaceData.isFeatureProject((IProject)((IProject)element));
                }
                return false;
            }
        }});
        if (dlg.open() != 0) {
            throw new OperationCanceledException();
        }
        IProject[] ps = dlg.getMultiResult();
        context.set(KEY_FEATURE, Arrays.stream(ps).map(e -> wb.getFeature(e.getName())).collect(Collectors.toList()));
        context.set(KEY_SITE_NAME, (Object)"dynamic_site");
        context.set(KEY_STRICT, (Object)Boolean.TRUE);
    }

    @TaskChainContextInit
    public void init(TaskExecutionContext c, TaskingLog log, @Named(value="feature_to_export") @Named(value="feature_to_export") List<FeatureBuild> fbs, @Named(value="feature_site_name") @Named(value="feature_site_name") String name, @Named(value="feature_strict_versions") @Named(value="feature_strict_versions") Boolean strict) {
        boolean first = true;
        ArrayList updates = new ArrayList();
        for (FeatureBuild fb : fbs) {
            File featureDir = ((FeatureData)fb.getData()).getBundleDir();
            File propFile = new File(featureDir, "content.properties");
            if (propFile.exists()) {
                Properties p = new Properties();
                try {
                    Throwable throwable = null;
                    Object var14_16 = null;
                    try (FileInputStream fis = new FileInputStream(propFile);){
                        p.load(fis);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace(log.error());
                }
                if (p.containsKey("dependencies")) {
                    c.addTask((Object)new TaskGenFeatureFromLcDsl(fb.getFeatureName(), true));
                }
            }
            if (strict.booleanValue()) {
                c.addTask((Object)TaskUpdateStrictFeatureVersions.create((String)fb.getFeatureName(), updates));
            }
            c.addTask((Object)new TaskRunFeaturePluginJarExport(fb.getFeatureName(), !first));
            first = false;
        }
        c.addTask((Object)new TaskPublishFeatureUpdateSite(name, fbs.stream().map(e -> e.getFeatureName()).collect(Collectors.toList())));
        if (strict.booleanValue()) {
            updates.forEach(u -> c.addTask(u.restore()));
        }
    }
}

