/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.LocatorModelListener;
import org.eclipse.tcf.te.tcf.ui.navigator.PeerModelListener;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.tcf.te.ui.views.navigator.nodes.NewWizardNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ContentProvider
implements ICommonContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String CURRENT_USER_FILTER_ID = "org.eclipse.tcf.te.tcf.ui.navigator.PeersByCurrentUserFilter";
    private final NewWizardNode newConfigNode = new NewWizardNode("org.eclipse.tcf.te.tcf.ui.wizards.NewTargetWizard", Messages.ContentProvider_newNode, UIPlugin.getImage("NewPeerObject"), (Object)this);
    PeerModelListener peerModelListener = null;
    LocatorModelListener locatorModelListener = null;
    private final boolean showInvisible;
    INavigatorFilterService navFilterService = null;

    public ContentProvider() {
        this(false);
    }

    public ContentProvider(boolean showInvisible) {
        this.showInvisible = showInvisible;
    }

    final boolean isValueAdd(IPeer peer) {
        Assert.isNotNull((Object)peer);
        String value = (String)peer.getAttributes().get("ValueAdd");
        boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
        return isValueAdd;
    }

    final boolean isFiltered(IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        boolean filtered = false;
        if (!this.showInvisible) {
            filtered |= !peerNode.isVisible();
        }
        return filtered;
    }

    final boolean isFiltered(IPeer peer) {
        Assert.isNotNull((Object)peer);
        boolean filtered = false;
        filtered |= this.isValueAdd(peer);
        return filtered |= peer.getName() != null && (peer.getName().endsWith("Command Server") || peer.getName().endsWith("CLI Server"));
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_ELEMENTS;
        ICategory category = parentElement instanceof ICategory ? (ICategory)parentElement : null;
        String catID = category != null ? category.getId() : null;
        boolean allHidden = false;
        ICategory myTargetsCat = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.mytargets", false);
        ICategory neighborhoodCat = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.neighborhood", false);
        boolean bl = allHidden = neighborhoodCat != null && !neighborhoodCat.isEnabled() && myTargetsCat != null && !myTargetsCat.isEnabled();
        if (parentElement instanceof ICategory) {
            parentElement = "org.eclipse.tcf.te.ui.views.category.neighborhood".equals(catID) ? ModelManager.getLocatorModel() : ModelManager.getPeerModel();
        }
        if (parentElement instanceof IRoot && allHidden) {
            parentElement = ModelManager.getPeerModel();
        }
        if (parentElement instanceof IPeerModel) {
            IPeerModel model = (IPeerModel)parentElement;
            IPeerNode[] peerNodes = model.getPeerNodes();
            ArrayList<Object> candidates = new ArrayList<Object>();
            if ("org.eclipse.tcf.te.ui.views.category.favorites".equals(catID)) {
                IPeerNode[] iPeerNodeArray = peerNodes;
                int n = peerNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n2];
                    if (!this.isFiltered(peerNode)) {
                        ICategorizable categorizable = (ICategorizable)peerNode.getAdapter(ICategorizable.class);
                        if (categorizable == null) {
                            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peerNode, ICategorizable.class);
                        }
                        Assert.isNotNull((Object)categorizable);
                        boolean isFavorite = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                        if (isFavorite && !candidates.contains(peerNode)) {
                            candidates.add(peerNode);
                        }
                    }
                    ++n2;
                }
            } else if ("org.eclipse.tcf.te.ui.views.category.mytargets".equals(catID)) {
                IPeerNode[] iPeerNodeArray = peerNodes;
                int n = peerNodes.length;
                int n3 = 0;
                while (n3 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n3];
                    if (!this.isFiltered(peerNode)) {
                        ICategorizable categorizable = (ICategorizable)peerNode.getAdapter(ICategorizable.class);
                        if (categorizable == null) {
                            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peerNode, ICategorizable.class);
                        }
                        Assert.isNotNull((Object)categorizable);
                        boolean isMyTargets = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                        if (!isMyTargets) {
                            Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                            isMyTargets = true;
                        }
                        if (isMyTargets && !candidates.contains(peerNode)) {
                            candidates.add(peerNode);
                        }
                    }
                    ++n3;
                }
                candidates.add(0, this.newConfigNode);
            } else if (catID != null) {
                IPeerNode[] iPeerNodeArray = peerNodes;
                int n = peerNodes.length;
                int n4 = 0;
                while (n4 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n4];
                    if (!this.isFiltered(peerNode)) {
                        ICategorizable categorizable = (ICategorizable)peerNode.getAdapter(ICategorizable.class);
                        if (categorizable == null) {
                            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peerNode, ICategorizable.class);
                        }
                        Assert.isNotNull((Object)categorizable);
                        boolean belongsTo = category.belongsTo((Object)peerNode);
                        if (belongsTo && !candidates.contains(peerNode)) {
                            Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                            candidates.add(peerNode);
                        }
                    }
                    ++n4;
                }
            } else {
                IPeerNode[] iPeerNodeArray = peerNodes;
                int n = peerNodes.length;
                int n5 = 0;
                while (n5 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n5];
                    if (!this.isFiltered(peerNode) && !candidates.contains(peerNode)) {
                        candidates.add(peerNode);
                    }
                    ++n5;
                }
            }
            children = candidates.toArray();
        } else if (parentElement instanceof ILocatorModel) {
            ArrayList<Object> candidates = new ArrayList<Object>();
            if ("org.eclipse.tcf.te.ui.views.category.neighborhood".equals(catID)) {
                ILocatorNode[] iLocatorNodeArray = ModelManager.getLocatorModel().getLocatorNodes();
                int n = iLocatorNodeArray.length;
                int n6 = 0;
                while (n6 < n) {
                    ILocatorNode locatorNode = iLocatorNodeArray[n6];
                    if (!this.isFiltered(locatorNode.getPeer()) && !candidates.contains(locatorNode)) {
                        candidates.add(locatorNode);
                    }
                    ++n6;
                }
            } else {
                candidates.add(CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.neighborhood", false));
            }
            children = candidates.toArray();
        } else if (parentElement instanceof ILocatorNode) {
            ILocatorNode locatorNode = (ILocatorNode)parentElement;
            children = locatorNode.getChildren();
        }
        return children;
    }

    public Object[] getChildren(TreePath parentPath) {
        return parentPath != null ? this.getChildren(parentPath.getLastSegment()) : NO_ELEMENTS;
    }

    public Object getParent(final Object element) {
        if (element instanceof ILocatorNode) {
            final AtomicReference parent = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    parent.set(((ILocatorNode)element).getParent());
                }
            });
            if (parent.get() == null) {
                return CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.neighborhood", false);
            }
            return parent.get();
        }
        if (element instanceof IPeerNode) {
            IPeerModel category = null;
            String[] categoryIds = Managers.getCategoryManager().getCategoryIds(((IPeerNode)element).getPeerId());
            if (categoryIds != null && categoryIds.length > 0) {
                category = CategoriesExtensionPointManager.getInstance().getCategory(categoryIds[0], false);
            }
            return category != null ? category : ((IPeerNode)element).getModel();
        }
        if (element instanceof IPendingOperationNode) {
            return ((IPendingOperationNode)element).getParent();
        }
        return null;
    }

    public TreePath[] getParents(Object element) {
        ArrayList<TreePath> pathes = new ArrayList<TreePath>();
        if (element instanceof IPeerNode) {
            Object parent;
            ICategory favCategory;
            if (Managers.getCategoryManager().belongsTo("org.eclipse.tcf.te.ui.views.category.favorites", ((IPeerNode)element).getPeerId()) && (favCategory = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.favorites", false)) != null) {
                pathes.add(new TreePath(new Object[]{favCategory}));
            }
            if ((parent = this.getParent(element)) != null) {
                pathes.add(new TreePath(new Object[]{parent}));
            }
        }
        return pathes.toArray(new TreePath[pathes.size()]);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ILocatorNode) {
            return ((ILocatorNode)element).hasChildren();
        }
        Object[] children = this.getChildren(element);
        if (children != null && children.length > 0 && this.navFilterService != null) {
            ViewerFilter[] viewerFilterArray = this.navFilterService.getVisibleFilters(true);
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if ((children = filter.filter(null, element, children)) == null || children.length == 0) break;
                ++n2;
            }
        }
        return children != null && children.length > 0;
    }

    public boolean hasChildren(TreePath path) {
        return path != null ? this.hasChildren(path.getLastSegment()) : false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        Runnable runnable;
        if (this.peerModelListener != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    ModelManager.getPeerModel().removeListener((IPeerModelListener)ContentProvider.this.peerModelListener);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            IActivityManager manager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            manager.removeActivityManagerListener((IActivityManagerListener)this.peerModelListener);
            this.peerModelListener = null;
        }
        if (this.locatorModelListener != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    ModelManager.getLocatorModel().removeListener((ILocatorModelListener)ContentProvider.this.locatorModelListener);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            this.locatorModelListener = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        final IPeerModel peerModel = ModelManager.getPeerModel();
        final ILocatorModel locatorModel = ModelManager.getLocatorModel();
        if (this.peerModelListener == null && peerModel != null && viewer instanceof CommonViewer) {
            this.peerModelListener = new PeerModelListener(peerModel, (CommonViewer)viewer);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    peerModel.addListener((IPeerModelListener)ContentProvider.this.peerModelListener);
                }
            });
            IActivityManager manager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            manager.addActivityManagerListener((IActivityManagerListener)this.peerModelListener);
        }
        if (this.locatorModelListener == null && locatorModel != null && viewer instanceof CommonViewer) {
            this.locatorModelListener = new LocatorModelListener(locatorModel, (CommonViewer)viewer);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    locatorModel.addListener((ILocatorModelListener)ContentProvider.this.locatorModelListener);
                }
            });
        }
        if (peerModel != null && newInput instanceof IRoot) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IPeerModelRefreshService)peerModel.getService(IPeerModelRefreshService.class)).refresh(null);
                }
            });
        }
    }

    public void init(ICommonContentExtensionSite config) {
        Assert.isNotNull((Object)config);
        INavigatorContentService cs = config.getService();
        INavigatorFilterService iNavigatorFilterService = this.navFilterService = cs != null ? cs.getFilterService() : null;
        if (this.navFilterService instanceof NavigatorFilterService) {
            ICommonFilterDescriptor[] descriptors;
            final NavigatorFilterService filterService = (NavigatorFilterService)this.navFilterService;
            boolean activeFiltersChanged = false;
            ArrayList<String> activeFilderIds = new ArrayList<String>();
            ICommonFilterDescriptor[] iCommonFilterDescriptorArray = descriptors = filterService.getVisibleFilterDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ICommonFilterDescriptor descriptor = iCommonFilterDescriptorArray[n2];
                if (descriptor.getId() != null && !"".equals(descriptor.getId()) && filterService.isActive(descriptor.getId())) {
                    activeFilderIds.add(descriptor.getId());
                }
                ++n2;
            }
            if (UIPlugin.getDefault().getPreferenceStore().getBoolean("te.tcf.ui.model.currentUserFilter.activate") && !this.navFilterService.isActive(CURRENT_USER_FILTER_ID)) {
                IDialogSettings settings = UIPlugin.getDefault().getDialogSettings();
                IDialogSettings section = settings.getSection(this.getClass().getSimpleName());
                if (section == null) {
                    section = settings.addNewSection(this.getClass().getSimpleName());
                }
                if (!section.getBoolean("te.tcf.ui.model.currentUserFilter.activate.done")) {
                    activeFilderIds.add(CURRENT_USER_FILTER_ID);
                    activeFiltersChanged = true;
                    section.put("te.tcf.ui.model.currentUserFilter.activate.done", true);
                }
            }
            if (activeFiltersChanged) {
                final String[] finActiveFilterIds = activeFilderIds.toArray(new String[activeFilderIds.size()]);
                DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        filterService.activateFilterIdsAndUpdateViewer(finActiveFilterIds);
                    }
                });
            }
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

