/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.profiler;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tcf.internal.debug.model.TCFFunctionRef;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.profiler.ProfilerSettingsDlg;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ProfilerView
extends ViewPart {
    private static final int FRAME_COUNT = 8;
    private static final String PARAM_VIEW_UPDATE_PERIOD = "ViewUpdatePeriod";
    private static final String PARAM_AGGREGATE = "Aggregate";
    private static final String PARAM_STACK_TRACE = "StackTrace";
    private final IDebugContextListener selection_listener = new IDebugContextListener(){

        public void debugContextChanged(DebugContextEvent event) {
            ProfilerView.this.selectionChanged(event.getContext());
        }
    };
    private final TCFModelManager.ModelManagerListener launch_listener = new TCFModelManager.ModelManagerListener(){

        @Override
        public void onConnected(TCFLaunch launch, TCFModel model) {
        }

        @Override
        public void onDisconnected(TCFLaunch launch, TCFModel model) {
            ProfileModel prf_model = (ProfileModel)ProfilerView.this.models.remove(model);
            if (prf_model != null) {
                model.removeProfilerDataListener(prf_model);
            }
            ProfilerView.this.updateView();
        }
    };
    private final Action action_start = new Action("Start", ImageCache.getImageDescriptor("icons/full/obj16/thread_obj")){

        public void run() {
            final TCFNode node = ProfilerView.this.selection;
            if (node == null) {
                return;
            }
            Map conf = (Map)new TCFTask<Map<String, Object>>(){

                public void run() {
                    this.done(ProfilerView.this.getConfiguration(node));
                }
            }.getE();
            ProfilerSettingsDlg dlg = new ProfilerSettingsDlg(ProfilerView.this.getSite().getShell(), conf);
            if (dlg.open() == 0) {
                final Map<String, Object> params = dlg.data;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProfilerView.this.configuration.put(node.getID(), params);
                        Integer n = (Integer)params.get(ProfilerView.PARAM_VIEW_UPDATE_PERIOD);
                        if (n != null) {
                            node.getModel().setProfilerReadDelay(n.intValue());
                        }
                        if (ProfilerView.this.selection != node) {
                            return;
                        }
                        ProfilerView.this.start(ProfilerView.this.selection);
                    }
                });
            }
        }
    };
    private final Action action_stop = new Action("Stop", ImageCache.getImageDescriptor("icons/full/obj16/threads_obj")){

        public void run() {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProfilerView.this.selection == null) {
                        return;
                    }
                    ProfilerView.this.stop(ProfilerView.this.selection);
                }
            });
        }
    };
    private boolean disposed;
    private TCFNode selection;
    private int sorting;
    private Update last_update;
    private Composite parent;
    private Label status;
    private TableViewer viewer_main;
    private TableViewer viewer_up;
    private TableViewer viewer_dw;
    private Composite main_composite;
    private TCFNode profile_node;
    private int sample_count;
    private boolean total_count;
    private HashMap<RGB, Color> colors = new HashMap();
    private static final String[] column_ids = new String[]{"Address", "% Exclusive", "% Inclusive", "Function", "File", "Line"};
    private static final int[] column_size = new int[]{80, 60, 60, 250, 250, 60};
    private final Map<String, Map<String, Object>> configuration = new HashMap<String, Map<String, Object>>();
    private final Map<TCFModel, ProfileModel> models = new HashMap<TCFModel, ProfileModel>();

    public void createPartControl(Composite parent) {
        assert (!this.disposed);
        this.parent = parent;
        Font font = parent.getFont();
        final Composite composite = new Composite(parent, 524544);
        composite.setFont(font);
        composite.setLayoutData((Object)new GridData(1808));
        this.main_composite = composite;
        final Composite table = this.createTable(composite);
        composite.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point p = table.computeSize(-1, hHint, flushCache);
                if (p.x < wHint) {
                    p.x = wHint;
                }
                p.y = hHint;
                return p;
            }

            protected void layout(Composite composite, boolean flushCache) {
                while (true) {
                    Rectangle rc = composite.getClientArea();
                    Point p = table.computeSize(-1, rc.height, true);
                    if (p.x < rc.width) {
                        p.x = rc.width;
                    }
                    ScrollBar sb = composite.getHorizontalBar();
                    int pos = 0;
                    boolean vis = sb.getVisible();
                    if (p.x > rc.width) {
                        pos = sb.getSelection();
                        if (pos > p.x - rc.width) {
                            pos = p.x - rc.width;
                        }
                        sb.setValues(pos, 0, p.x, rc.width, 1, 1);
                    }
                    table.setBounds(-pos, rc.y, p.x, rc.height);
                    if (vis == p.x > rc.width) break;
                    sb.setVisible(!vis);
                }
            }
        });
        composite.getHorizontalBar().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Point location = table.getLocation();
                ScrollBar sb = composite.getHorizontalBar();
                int pos = sb.getSelection();
                table.setLocation(-pos, location.y);
            }
        });
        this.action_start.setEnabled(false);
        this.action_stop.setEnabled(false);
        IActionBars action_bars = this.getViewSite().getActionBars();
        IToolBarManager tool_bar = action_bars.getToolBarManager();
        tool_bar.add((IAction)this.action_start);
        tool_bar.add((IAction)this.action_stop);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TCFModelManager.getModelManager().addListener(ProfilerView.this.launch_listener);
            }
        });
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IDebugContextService dcs = DebugUITools.getDebugContextManager().getContextService(window);
        dcs.addDebugContextListener(this.selection_listener);
        ISelection active_context = dcs.getActiveContext();
        this.selectionChanged(active_context);
    }

    private Composite createTable(Composite parent) {
        Font font = parent.getFont();
        final Composite composite = new Composite(parent, 524288);
        FormLayout layout = new FormLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        Composite main = this.createMainTable(composite);
        final Sash sash = new Sash(composite, 256);
        Composite details = this.createDetailsPane(composite);
        FormData form_data_main = new FormData();
        form_data_main.left = new FormAttachment(0, 0);
        form_data_main.right = new FormAttachment(100, 0);
        form_data_main.top = new FormAttachment(0, 0);
        form_data_main.bottom = new FormAttachment((Control)sash, 0);
        main.setLayoutData((Object)form_data_main);
        final FormData form_data_sash = new FormData();
        form_data_sash.left = new FormAttachment(0, 0);
        form_data_sash.right = new FormAttachment(100, 0);
        form_data_sash.top = new FormAttachment(60, 0);
        sash.setLayoutData((Object)form_data_sash);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect_sash = sash.getBounds();
                Rectangle rect_view = composite.getClientArea();
                int top = rect_view.height - rect_sash.height - 20;
                e.y = Math.max(Math.min(e.y, top), 20);
                if (e.y != rect_sash.y) {
                    form_data_sash.top = new FormAttachment(0, e.y);
                    composite.layout();
                }
            }
        });
        FormData form_data_details = new FormData();
        form_data_details.left = new FormAttachment(0, 0);
        form_data_details.right = new FormAttachment(100, 0);
        form_data_details.top = new FormAttachment((Control)sash, 0);
        form_data_details.bottom = new FormAttachment(100, 0);
        details.setLayoutData((Object)form_data_details);
        return composite;
    }

    private Composite createMainTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 526336);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        this.status = new Label(composite, 0);
        this.status.setFont(font);
        this.status.setLayoutData((Object)new GridData(768));
        this.viewer_main = new TableViewer(composite, 66050);
        final Table table = this.viewer_main.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.viewer_main.setContentProvider((IContentProvider)new ProfileContentProvider());
        this.viewer_main.setLabelProvider((IBaseLabelProvider)new ProfileEntryLabelProvider());
        this.viewer_main.setColumnProperties(column_ids);
        int i = 0;
        while (i < column_ids.length) {
            this.createColumn(table, i);
            ++i;
        }
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfilerView.this.disposeColors();
                if (e.item == null) {
                    return;
                }
                ProfileEntry pe = (ProfileEntry)ProfilerView.this.viewer_main.getElementAt(table.indexOf((TableItem)e.item));
                ProfilerView.this.viewer_up.setInput((Object)pe.up);
                ProfilerView.this.viewer_dw.setInput((Object)pe.dw);
                ProfilerView.this.displaySource(pe);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1 || event.index == 2 && ProfilerView.this.total_count) {
                    int index = table.indexOf((TableItem)event.item);
                    ProfileEntry pe = ((ProfileEntry[])ProfilerView.this.viewer_main.getInput())[index];
                    float count = event.index == 1 ? (float)pe.count : pe.total;
                    ProfilerView.this.paintPercent(event, count);
                }
            }
        });
        return composite;
    }

    private Composite createDetailsPane(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 526336);
        composite.setFont(font);
        final Label label_up = new Label(composite, 0);
        label_up.setFont(font);
        label_up.setText("Called From");
        this.viewer_up = new TableViewer(composite, 66048);
        final Table table_up = this.viewer_up.getTable();
        table_up.setHeaderVisible(false);
        table_up.setLinesVisible(true);
        table_up.setFont(font);
        this.viewer_up.setContentProvider((IContentProvider)new ProfileContentProvider());
        this.viewer_up.setLabelProvider((IBaseLabelProvider)new ProfileEntryRefLabelProvider());
        this.viewer_up.setColumnProperties(column_ids);
        table_up.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                ProfilerView.this.displaySource(((ProfileEntryRef)((ProfilerView)ProfilerView.this).viewer_up.getElementAt((int)table_up.indexOf((TableItem)((TableItem)e.item)))).pe);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                ProfilerView.this.displayEntry(((ProfileEntryRef)((ProfilerView)ProfilerView.this).viewer_up.getElementAt((int)table_up.indexOf((TableItem)((TableItem)e.item)))).pe);
            }
        });
        table_up.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 2) {
                    int index = table_up.indexOf((TableItem)event.item);
                    ProfileEntryRef pe = ((ProfileEntryRef[])ProfilerView.this.viewer_up.getInput())[index];
                    ProfilerView.this.paintPercent(event, pe.total);
                }
            }
        });
        final Label separator = new Label(composite, 258);
        separator.setFont(font);
        final Label label_dw = new Label(composite, 0);
        label_dw.setFont(font);
        label_dw.setText("Child Calls");
        this.viewer_dw = new TableViewer(composite, 66048);
        final Table table_dw = this.viewer_dw.getTable();
        table_dw.setHeaderVisible(false);
        table_dw.setLinesVisible(true);
        table_dw.setFont(font);
        this.viewer_dw.setContentProvider((IContentProvider)new ProfileContentProvider());
        this.viewer_dw.setLabelProvider((IBaseLabelProvider)new ProfileEntryRefLabelProvider());
        this.viewer_dw.setColumnProperties(column_ids);
        table_dw.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                ProfilerView.this.displaySource(((ProfileEntryRef)((ProfilerView)ProfilerView.this).viewer_dw.getElementAt((int)table_dw.indexOf((TableItem)((TableItem)e.item)))).pe);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                ProfilerView.this.displayEntry(((ProfileEntryRef)((ProfilerView)ProfilerView.this).viewer_dw.getElementAt((int)table_dw.indexOf((TableItem)((TableItem)e.item)))).pe);
            }
        });
        table_dw.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 2) {
                    int index = table_dw.indexOf((TableItem)event.item);
                    ProfileEntryRef pe = ((ProfileEntryRef[])ProfilerView.this.viewer_dw.getInput())[index];
                    ProfilerView.this.paintPercent(event, pe.total);
                }
            }
        });
        int i = 0;
        while (i < column_ids.length) {
            this.createColumn(table_up, i);
            this.createColumn(table_dw, i);
            ++i;
        }
        composite.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point l_up = label_up.computeSize(wHint, -1);
                Point t_up = table_up.computeSize(wHint, -1);
                Point sep = separator.computeSize(wHint, -1);
                Point l_dw = label_dw.computeSize(wHint, -1);
                Point t_dw = table_dw.computeSize(wHint, -1);
                int w = 0;
                if (l_up.x > w) {
                    w = l_up.x;
                }
                if (t_up.x > w) {
                    w = t_up.x;
                }
                if (sep.x > w) {
                    w = sep.x;
                }
                if (l_dw.x > w) {
                    w = l_dw.x;
                }
                if (t_dw.x > w) {
                    w = t_dw.x;
                }
                int h = l_up.y + t_up.y + sep.y + l_dw.y + t_dw.y;
                return new Point(w, h);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle rc = composite.getClientArea();
                Point l_up = label_up.computeSize(rc.width, -1);
                Point sep = separator.computeSize(rc.width, -1);
                Point l_dw = label_dw.computeSize(rc.width, -1);
                int h = (rc.height - l_up.y - sep.y - l_dw.y) / 2;
                if (h < 0) {
                    h = 0;
                }
                int y = rc.y;
                label_up.setBounds(rc.x, y, rc.width, l_up.y);
                table_up.setBounds(rc.x, y += l_up.y, rc.width, h);
                separator.setBounds(rc.x, y += h, rc.width, sep.y);
                label_dw.setBounds(rc.x, y += sep.y, rc.width, l_dw.y);
                table_dw.setBounds(rc.x, y += l_dw.y, rc.width, h);
            }
        });
        return composite;
    }

    private void createColumn(final Table table, int i) {
        final int n = i;
        final TableColumn c = new TableColumn(table, 0, i);
        c.setText(column_ids[i]);
        c.setWidth(column_size[i]);
        if (i != 5) {
            c.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    table.setSortDirection(1024);
                    table.setSortColumn(c);
                    ProfilerView.this.sorting = n;
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfilerView.this.updateView();
                        }
                    });
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (table == this.viewer_main.getTable()) {
            c.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    int w = c.getWidth();
                    if (n == column_size.length - 1 && !System.getProperty("os.name", "").startsWith("Windows") && w > column_size[n]) {
                        w = column_size[n];
                    }
                    if (ProfilerView.this.viewer_up.getTable().getColumn(n).getWidth() == w && ProfilerView.this.viewer_dw.getTable().getColumn(n).getWidth() == w) {
                        return;
                    }
                    ProfilerView.this.viewer_up.getTable().getColumn(n).setWidth(w);
                    ProfilerView.this.viewer_dw.getTable().getColumn(n).setWidth(w);
                    ProfilerView.this.main_composite.layout();
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            if (i == 2) {
                table.setSortDirection(1024);
                table.setSortColumn(c);
                this.sorting = i;
            }
        }
    }

    private String toHex(BigInteger n) {
        String s = n.toString(16);
        if (s.length() >= 8) {
            return s;
        }
        return String.valueOf("00000000".substring(s.length())) + s;
    }

    private void disposeColors() {
        for (Color c : this.colors.values()) {
            c.dispose();
        }
        this.colors.clear();
    }

    private Color getColor(RGB rgb) {
        Color c = this.colors.get(rgb);
        if (c == null) {
            c = new Color((Device)this.parent.getDisplay(), rgb);
            this.colors.put(rgb, c);
        }
        return c;
    }

    private String toPercent(float x) {
        float f = x * 100.0f / (float)this.sample_count;
        String s = String.format("%.3f", Float.valueOf(f));
        int l = s.indexOf(46);
        s = l >= 3 ? "100" : (l >= 2 ? s.substring(0, 4) : (s.charAt(0) == '0' ? s.substring(1) : s.substring(0, 4)));
        return s;
    }

    private void paintPercent(Event event, float count) {
        Table table = (Table)event.widget;
        int cell_width = table.getColumn(event.index).getWidth() - 1;
        if (cell_width > 2) {
            GC gc = event.gc;
            float percent = count * 100.0f / (float)this.sample_count;
            int width = (int)((float)cell_width * percent / 100.0f);
            if (width > cell_width) {
                width = cell_width;
            }
            if (width >= 2) {
                Color bg = gc.getBackground();
                Color fg = gc.getForeground();
                gc.setBackground(this.getColor(new RGB(bg.getRed() / 3 + 170, bg.getGreen() / 3 + 170, bg.getBlue() / 3)));
                gc.setForeground(this.getColor(new RGB(bg.getRed() / 3 + 170, bg.getGreen() / 3, bg.getBlue() / 3)));
                gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
                gc.drawRectangle(new Rectangle(event.x, event.y, width - 1, event.height - 1));
                gc.setBackground(bg);
                gc.setForeground(fg);
            }
            String text = this.toPercent(count);
            Point size = event.gc.textExtent(text);
            int offset = Math.max(0, (event.height - size.y) / 2);
            gc.drawText(text, event.x + 2, event.y + offset, true);
        }
    }

    private void selectionChanged(ISelection s) {
        if (s instanceof IStructuredSelection) {
            final Object obj = ((IStructuredSelection)s).getFirstElement();
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (obj instanceof TCFNode) {
                        ProfilerView.this.selection = (TCFNode)obj;
                    } else {
                        ProfilerView.this.selection = null;
                    }
                    ProfilerView.this.updateView();
                }
            });
        }
    }

    private void setSelection(List<ProfileEntry> l, boolean reveal) {
        this.viewer_main.setSelection((ISelection)new StructuredSelection(l), reveal);
        if (l.size() == 0) {
            this.viewer_up.setInput(null);
            this.viewer_dw.setInput(null);
        } else {
            ProfileEntry pe = l.get(0);
            this.viewer_up.setInput((Object)pe.up);
            this.viewer_dw.setInput((Object)pe.dw);
        }
    }

    private void setSelection(ProfileEntry pe, boolean reveal) {
        ArrayList<ProfileEntry> l = new ArrayList<ProfileEntry>();
        if (pe != null) {
            l.add(pe);
        }
        this.setSelection(l, reveal);
    }

    private void displaySource(ProfileEntry pe) {
        if (this.profile_node == null) {
            return;
        }
        if (pe.file_full == null) {
            return;
        }
        this.profile_node.getModel().displaySource(this.profile_node.getID(), pe.file_full, pe.line);
    }

    private void displayEntry(ProfileEntry pe) {
        this.setSelection(pe, true);
    }

    public void setFocus() {
        this.viewer_main.getControl().setFocus();
    }

    private void asyncExec(Runnable r) {
        try {
            this.parent.getDisplay().asyncExec(r);
        }
        catch (SWTException sWTException) {}
    }

    private Map<String, Object> getConfiguration(TCFNode node) {
        String ctx = node.getID();
        Map<String, Object> params = this.configuration.get(ctx);
        if (params == null) {
            params = new HashMap<String, Object>();
            params.put("FrameCnt", 8);
            params.put(PARAM_AGGREGATE, Boolean.TRUE);
            params.put(PARAM_STACK_TRACE, Boolean.FALSE);
            this.configuration.put(ctx, params);
        }
        params.put(PARAM_VIEW_UPDATE_PERIOD, node.getModel().getProfilerReadDelay());
        return params;
    }

    private void start(TCFNode node) {
        assert (Protocol.isDispatchThread());
        this.configure(node, this.getConfiguration(node));
    }

    private void stop(TCFNode node) {
        assert (Protocol.isDispatchThread());
        this.configure(node, null);
    }

    private void configure(TCFNode node, Map<String, Object> params) {
        TCFModel model = node.getModel();
        Map<String, Object> prf_cfg = model.getProfilerConfiguration(node.getID());
        if (params != null) {
            Object frame_cnt = null;
            Boolean stack_trace = (Boolean)params.get(PARAM_STACK_TRACE);
            if (stack_trace != null && stack_trace.booleanValue()) {
                frame_cnt = params.get("FrameCnt");
            }
            if (frame_cnt == null) {
                frame_cnt = 1;
            }
            prf_cfg.put("FrameCnt", frame_cnt);
        } else {
            prf_cfg.remove("FrameCnt");
        }
        model.sendProfilerConfiguration(node.getID());
        ProfileModel prf_model = this.models.get(model);
        if (params == null) {
            ProfileData prf_data = null;
            if (prf_model != null) {
                prf_data = prf_model.data.get(node.getID());
            }
            if (prf_data != null) {
                prf_data.stopped = true;
            }
        } else {
            ProfileData d = new ProfileData(node.getID(), params);
            if (prf_model == null) {
                prf_model = new ProfileModel();
                this.models.put(node.getModel(), prf_model);
                model.addProfilerDataListener(prf_model);
            }
            prf_model.data.put(d.ctx, d);
        }
        this.updateView();
    }

    private void addSamples(ProfileData p, Map<String, Object> props) {
        byte[] data;
        Boolean b;
        int size = 4;
        boolean big_endian = false;
        Number n = (Number)props.get("AddrSize");
        if (n != null) {
            size = n.intValue();
        }
        if ((b = (Boolean)props.get("BigEndian")) != null) {
            big_endian = b;
        }
        if ((data = JSON.toByteArray((Object)props.get("Data"))) == null || data.length == 0) {
            return;
        }
        int pos = 0;
        byte[] buf = new byte[size + 1];
        BigInteger[] trace = new BigInteger[p.map.length];
        while (true) {
            int c = -1;
            int l = -1;
            int i = 0;
            while (pos + size <= data.length) {
                int j = 0;
                while (j < size) {
                    buf[big_endian ? j + 1 : size - j] = data[pos++];
                    ++j;
                }
                if (i >= trace.length) continue;
                BigInteger a = new BigInteger(buf);
                if (c < 0) {
                    c = a.intValue();
                    continue;
                }
                if (l < 0) {
                    l = a.intValue();
                    continue;
                }
                trace[i++] = a;
                if (i == l) break;
            }
            if (l < 0) break;
            if (i <= 0) continue;
            this.addSample(p, trace, i, c);
        }
        this.updateView();
    }

    private void addSample(ProfileData p, BigInteger[] trace, int len, int cnt) {
        assert (len > 0);
        p.sample_count += cnt;
        ++p.generation_inp;
        ProfileSample ps = null;
        if (len > p.map.length) {
            len = p.map.length;
        }
        int f = 0;
        while (f < p.map.length && f < len) {
            block10: {
                List<ProfileSample> lp;
                block9: {
                    block8: {
                        lp = p.map[f].get(trace[f]);
                        if (lp == null) break block8;
                        boolean ok = false;
                        for (ProfileSample s : lp) {
                            if (len != s.trace.length) continue;
                            int i = 0;
                            while (i < len && trace[i].equals(s.trace[i])) {
                                ++i;
                            }
                            if (i != len) continue;
                            assert (ps == null || ps == s);
                            ps = s;
                            ok = true;
                        }
                        if (!ok) break block9;
                        break block10;
                    }
                    lp = new ArrayList<ProfileSample>();
                    p.map[f].put(trace[f], lp);
                }
                if (ps == null) {
                    BigInteger[] t = new BigInteger[len];
                    int i = 0;
                    while (i < len) {
                        t[i] = trace[i];
                        ++i;
                    }
                    ps = new ProfileSample(t);
                }
                lp.add(ps);
            }
            ++f;
        }
        ps.cnt += cnt;
    }

    private void updateView() {
        assert (Protocol.isDispatchThread());
        Protocol.invokeLater((Runnable)new Update());
    }

    public void dispose() {
        this.disposed = true;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TCFModelManager.getModelManager().removeListener(ProfilerView.this.launch_listener);
                ProfilerView.this.models.clear();
            }
        });
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IDebugContextService dcs = DebugUITools.getDebugContextManager().getContextService(window);
        dcs.removeDebugContextListener(this.selection_listener);
        this.disposeColors();
        super.dispose();
    }

    static /* synthetic */ void access$22(ProfilerView profilerView, Runnable runnable) {
        profilerView.asyncExec(runnable);
    }

    private class ProfileContentProvider
    implements IStructuredContentProvider {
        private ProfileContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (Object[])input;
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private static class ProfileData {
        final String ctx;
        final Map<String, Object> params;
        final boolean stack_trace;
        boolean stopped;
        boolean unsupported;
        Exception error;
        int sample_count;
        final Map<BigInteger, List<ProfileSample>>[] map;
        int generation_inp;
        int generation_out;
        ProfileEntry[] entries;

        ProfileData(String ctx, Map<String, Object> params) {
            Number n;
            this.ctx = ctx;
            this.params = new HashMap<String, Object>(params);
            Boolean b = (Boolean)params.get(ProfilerView.PARAM_STACK_TRACE);
            this.stack_trace = b != null && b != false;
            int frame_cnt = 1;
            if (this.stack_trace && (n = (Number)params.get("FrameCnt")) != null) {
                frame_cnt = n.intValue();
            }
            this.map = new Map[frame_cnt];
            int i = 0;
            while (i < frame_cnt) {
                this.map[i] = new HashMap<BigInteger, List<ProfileSample>>();
                ++i;
            }
        }
    }

    private static class ProfileEntry {
        final BigInteger addr;
        final Set<BigInteger> addr_list = new HashSet<BigInteger>();
        String name;
        String file_full;
        String file_base;
        int line;
        int count;
        float total;
        ProfileEntryRef[] up;
        ProfileEntryRef[] dw;
        boolean src_info_valid;
        boolean mark;

        ProfileEntry(BigInteger addr) {
            this.addr = addr;
        }
    }

    private static class ProfileEntryComparator
    implements Comparator<ProfileEntry> {
        final int sorting;

        ProfileEntryComparator(int sorting) {
            this.sorting = sorting;
        }

        @Override
        public int compare(ProfileEntry x, ProfileEntry y) {
            int r = 0;
            switch (this.sorting) {
                case 0: {
                    r = x.addr.compareTo(y.addr);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (x.total > y.total) {
                        return -1;
                    }
                    if (!(x.total < y.total)) break;
                    return 1;
                }
                case 3: {
                    if (x.name == y.name) break;
                    if (x.name == null) {
                        return -1;
                    }
                    if (y.name == null) {
                        return 1;
                    }
                    r = x.name.compareTo(y.name);
                    break;
                }
                case 4: {
                    if (x.file_base == y.file_base) break;
                    if (x.file_base == null) {
                        return -1;
                    }
                    if (y.file_base == null) {
                        return 1;
                    }
                    r = x.file_base.compareTo(y.file_base);
                }
            }
            if (r != 0) {
                return r;
            }
            if (x.count > y.count) {
                return -1;
            }
            if (x.count < y.count) {
                return 1;
            }
            return x.addr.compareTo(y.addr);
        }
    }

    private class ProfileEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProfileEntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            ProfileEntry e = (ProfileEntry)element;
            switch (column) {
                case 0: {
                    return ProfilerView.this.toHex(e.addr);
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return e.name;
                }
                case 4: {
                    return e.file_base;
                }
                case 5: {
                    return e.line == 0 ? null : Integer.toString(e.line);
                }
            }
            return null;
        }
    }

    private static class ProfileEntryRef {
        final ProfileEntry pe;
        float total;

        ProfileEntryRef(ProfileEntry pe) {
            this.pe = pe;
        }
    }

    private static class ProfileEntryRefComparator
    implements Comparator<ProfileEntryRef> {
        private ProfileEntryRefComparator() {
        }

        @Override
        public int compare(ProfileEntryRef x, ProfileEntryRef y) {
            if (x.total > y.total) {
                return -1;
            }
            if (x.total < y.total) {
                return 1;
            }
            return x.pe.addr.compareTo(y.pe.addr);
        }
    }

    private class ProfileEntryRefLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProfileEntryRefLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            ProfileEntryRef e = (ProfileEntryRef)element;
            switch (column) {
                case 0: {
                    return ProfilerView.this.toHex(e.pe.addr);
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return e.pe.name;
                }
                case 4: {
                    return e.pe.file_base;
                }
                case 5: {
                    return e.pe.line == 0 ? null : Integer.toString(e.pe.line);
                }
            }
            return null;
        }
    }

    private class ProfileModel
    implements TCFModel.ProfilerDataListener {
        final Map<String, ProfileData> data = new HashMap<String, ProfileData>();

        private ProfileModel() {
        }

        @Override
        public void onDataReceived(String ctx, Map<String, Object>[] arr) {
            int cnt = 0;
            ProfileData p = this.data.get(ctx);
            if (p == null) {
                return;
            }
            if (p.stopped) {
                return;
            }
            Map<String, Object>[] mapArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String format;
                Map<String, Object> props = mapArray[n2];
                if (props != null && (format = (String)props.get("Format")) != null && format.equals("StackTraces")) {
                    ProfilerView.this.addSamples(p, props);
                    ++cnt;
                }
                ++n2;
            }
            if (p.unsupported != (cnt == 0)) {
                p.unsupported = cnt == 0;
                ProfilerView.this.updateView();
            }
        }
    }

    private static class ProfileSample {
        int cnt;
        final BigInteger[] trace;

        ProfileSample(BigInteger[] trace) {
            this.trace = trace;
        }
    }

    private class Update
    implements Runnable {
        final int sorting;
        final TCFNode selection;
        final Map<BigInteger, ProfileEntry> entries = new HashMap<BigInteger, ProfileEntry>();
        final Map<BigInteger, BigInteger> addr_to_func_addr = new HashMap<BigInteger, BigInteger>();
        final Map<BigInteger, String> addr_to_func_id = new HashMap<BigInteger, String>();
        final TCFNodeExecContext node;
        final ProfileData prof_data;
        final TCFModel model;
        final boolean aggrerate;
        final int generation;
        TCFNodeExecContext mem_node;
        TCFDataCache<?> pending;
        boolean done;

        Update() {
            ProfileModel m;
            assert (Protocol.isDispatchThread());
            this.selection = ProfilerView.this.selection;
            this.sorting = ProfilerView.this.sorting;
            ProfileData p = null;
            if (this.selection != null && (m = (ProfileModel)ProfilerView.this.models.get(this.selection.getModel())) != null) {
                p = m.data.get(this.selection.getID());
            }
            this.prof_data = p;
            if (p == null) {
                this.node = null;
                this.model = null;
                this.generation = 0;
                this.aggrerate = false;
            } else {
                this.node = (TCFNodeExecContext)this.selection;
                this.model = this.selection.getModel();
                this.generation = p.generation_inp;
                Boolean b = (Boolean)p.params.get(ProfilerView.PARAM_AGGREGATE);
                this.aggrerate = b != null && b != false;
            }
            ProfilerView.this.last_update = this;
        }

        private String getFuncID(BigInteger addr) {
            String func_id = this.addr_to_func_id.get(addr);
            if (func_id == null) {
                func_id = "";
                TCFDataCache<TCFFunctionRef> func_cache = this.mem_node.getFuncInfo(addr);
                if (func_cache != null) {
                    if (!func_cache.validate()) {
                        this.pending = func_cache;
                        return null;
                    }
                    TCFFunctionRef func_data = (TCFFunctionRef)func_cache.getData();
                    if (func_data != null && func_data.symbol_id != null) {
                        func_id = func_data.symbol_id;
                    }
                }
                this.addr_to_func_id.put(addr, func_id);
            }
            return func_id;
        }

        private BigInteger getFuncAddress(BigInteger addr) {
            if (!this.aggrerate) {
                return addr;
            }
            BigInteger func_addr = this.addr_to_func_addr.get(addr);
            if (func_addr != null) {
                return func_addr;
            }
            String func_id = this.getFuncID(addr);
            if (func_id == null) {
                return null;
            }
            func_addr = addr;
            if (func_id.length() > 0) {
                TCFDataCache<ISymbols.Symbol> sym_cache = this.model.getSymbolInfoCache(func_id);
                if (!sym_cache.validate()) {
                    this.pending = sym_cache;
                    return null;
                }
                ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                if (sym_data != null && sym_data.getAddress() != null) {
                    func_addr = JSON.toBigInteger((Number)sym_data.getAddress());
                }
            }
            this.addr_to_func_addr.put(addr, func_addr);
            return func_addr;
        }

        private boolean getFuncName(ProfileEntry pe) {
            String func_id = this.getFuncID(pe.addr);
            if (func_id == null) {
                return false;
            }
            if (func_id.length() > 0) {
                TCFDataCache<ISymbols.Symbol> sym_cache = this.model.getSymbolInfoCache(func_id);
                if (!sym_cache.validate()) {
                    this.pending = sym_cache;
                    return false;
                }
                ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                if (sym_data != null && sym_data.getName() != null) {
                    pe.name = sym_data.getName();
                }
            }
            return true;
        }

        private boolean getLineInfo(ProfileEntry pe) {
            TCFDataCache<TCFSourceRef> line_cache = this.mem_node.getLineInfo(pe.addr);
            if (line_cache == null) {
                return true;
            }
            if (!line_cache.validate()) {
                this.pending = line_cache;
                return false;
            }
            TCFSourceRef line_data = (TCFSourceRef)line_cache.getData();
            if (line_data != null && line_data.area != null) {
                pe.file_full = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)line_data.area);
                if (pe.file_full != null) {
                    int j;
                    pe.file_base = pe.file_full;
                    int i = pe.file_base.lastIndexOf(47);
                    if (i > (j = pe.file_base.lastIndexOf(92))) {
                        pe.file_base = pe.file_base.substring(i + 1);
                    }
                    if (i < j) {
                        pe.file_base = pe.file_base.substring(j + 1);
                    }
                    pe.line = line_data.area.start_line;
                }
            }
            return true;
        }

        private void linkEntry(ProfileEntry pe) {
            HashSet<ProfileEntry> set_up = new HashSet<ProfileEntry>();
            HashSet<ProfileEntry> set_dw = new HashSet<ProfileEntry>();
            int n = 0;
            while (n < this.prof_data.map.length) {
                for (BigInteger addr : pe.addr_list) {
                    List<ProfileSample> s1;
                    List<ProfileSample> s0 = this.prof_data.map[n].get(addr);
                    if (s0 != null) {
                        for (ProfileSample x : s0) {
                            assert (addr.equals(x.trace[n]));
                            if (x.trace.length <= n + 1) continue;
                            BigInteger addr_up = this.getFuncAddress(x.trace[n + 1]);
                            ProfileEntry pe_up = this.entries.get(addr_up);
                            set_up.add(pe_up);
                        }
                    }
                    if (n == this.prof_data.map.length - 1 || (s1 = this.prof_data.map[n + 1].get(addr)) == null) continue;
                    for (ProfileSample x : s1) {
                        assert (x.trace.length > n + 1);
                        assert (addr.equals(x.trace[n + 1]));
                        BigInteger addr_dw = this.getFuncAddress(x.trace[n]);
                        ProfileEntry pe_dw = this.entries.get(addr_dw);
                        set_dw.add(pe_dw);
                    }
                }
                ++n;
            }
            if (set_up.size() > 0) {
                n = 0;
                pe.up = new ProfileEntryRef[set_up.size()];
                for (ProfileEntry p : set_up) {
                    pe.up[n++] = new ProfileEntryRef(p);
                }
            }
            if (set_dw.size() > 0) {
                n = 0;
                pe.dw = new ProfileEntryRef[set_dw.size()];
                for (ProfileEntry p : set_dw) {
                    pe.dw[n++] = new ProfileEntryRef(p);
                }
            }
        }

        private void addUpTotal(ProfileEntry pe, float cnt) {
            if (cnt <= 0.01f || pe.up == null) {
                return;
            }
            pe.mark = true;
            int n = 0;
            ProfileEntryRef[] profileEntryRefArray = pe.up;
            int n2 = pe.up.length;
            int n3 = 0;
            while (n3 < n2) {
                ProfileEntryRef up = profileEntryRefArray[n3];
                if (!up.pe.mark) {
                    ++n;
                }
                ++n3;
            }
            if (n != 0) {
                float m = cnt / (float)n;
                ProfileEntryRef[] profileEntryRefArray2 = pe.up;
                int n4 = pe.up.length;
                n2 = 0;
                while (n2 < n4) {
                    ProfileEntryRef up = profileEntryRefArray2[n2];
                    if (!up.pe.mark) {
                        this.addUpTotal(up.pe, m * 1.0001f);
                        up.pe.total += m;
                        up.total += m;
                        ProfileEntryRef[] profileEntryRefArray3 = up.pe.dw;
                        int n5 = up.pe.dw.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ProfileEntryRef dw = profileEntryRefArray3[n6];
                            if (dw.pe == pe) {
                                dw.total += m;
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n2;
                }
            }
            pe.mark = false;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block32: {
                block34: {
                    block33: {
                        this.pending = null;
                        this.mem_node = null;
                        if (this.done) {
                            return;
                        }
                        if (ProfilerView.access$11(ProfilerView.this) != this) {
                            return;
                        }
                        capabilities_ok = false;
                        if (this.selection instanceof TCFNodeExecContext) {
                            cache = this.selection.getModel().getProfilerCapabilities(this.selection.getID());
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            map = (Map)cache.getData();
                            v0 = capabilities_ok = map == null || map.containsKey("StackTraces") != false;
                        }
                        if (this.prof_data == null || this.generation == this.prof_data.generation_out) break block32;
                        if (!this.node.isDisposed()) break block33;
                        this.entries.clear();
                        break block34;
                    }
                    mem_cache = this.node.getMemoryNode();
                    if (!mem_cache.validate()) {
                        this.pending = mem_cache;
                    } else {
                        this.mem_node = (TCFNodeExecContext)mem_cache.getData();
                    }
                    if (this.mem_node != null) {
                        n = 0;
                        while (n < this.prof_data.map.length) {
                            for (Object addr : this.prof_data.map[n].keySet()) {
                                func_addr = this.getFuncAddress((BigInteger)addr);
                                if (func_addr == null) continue;
                                pe = this.entries.get(func_addr);
                                if (pe == null) {
                                    pe = new ProfileEntry(func_addr);
                                    this.entries.put(pe.addr, pe);
                                }
                                if (!pe.addr_list.contains(addr)) {
                                    if (n == 0) {
                                        s = this.prof_data.map[0].get(addr);
                                        for (ProfileSample x : s) {
                                            pe.count += x.cnt;
                                        }
                                    }
                                    pe.addr_list.add((BigInteger)addr);
                                }
                                if (pe.src_info_valid) continue;
                                pe.src_info_valid = true;
                                if (!this.getFuncName(pe)) {
                                    pe.src_info_valid = false;
                                }
                                if (this.getLineInfo(pe)) continue;
                                pe.src_info_valid = false;
                            }
                            ++n;
                        }
                    }
                    if (this.pending != null) {
                        this.pending.wait((Runnable)this);
                        return;
                    }
                    for (ProfileEntry pe : this.entries.values()) {
                        this.linkEntry(pe);
                    }
                    for (List lps : this.prof_data.map[0].values()) {
                        for (ProfileSample ps : lps) {
                            n = 0;
                            dw_pe = null;
                            pe = null;
                            up_pe = null;
                            if (Update.$assertionsDisabled || ps.trace.length <= this.prof_data.map.length) ** GOTO lbl99
                            throw new AssertionError();
lbl-1000:
                            // 1 sources

                            {
                                cnt = (float)ps.cnt * (1.0f + (float)n / 10000.0f);
                                if (pe == null) {
                                    pe = this.entries.get(this.getFuncAddress(ps.trace[n]));
                                }
                                if (dw_pe != null) {
                                    var15_25 = pe.dw;
                                    var14_24 = pe.dw.length;
                                    var13_23 = 0;
                                    while (var13_23 < var14_24) {
                                        r = var15_25[var13_23];
                                        if (r.pe == dw_pe) {
                                            r.total += cnt;
                                            break;
                                        }
                                        ++var13_23;
                                    }
                                }
                                if (n < ps.trace.length - 1) {
                                    up_pe = this.entries.get(this.getFuncAddress(ps.trace[n + 1]));
                                    var15_25 = pe.up;
                                    var14_24 = pe.up.length;
                                    var13_23 = 0;
                                    while (var13_23 < var14_24) {
                                        r = var15_25[var13_23];
                                        if (r.pe == up_pe) {
                                            r.total += cnt;
                                            break;
                                        }
                                        ++var13_23;
                                    }
                                } else {
                                    this.addUpTotal(pe, cnt);
                                }
                                pe.total += cnt;
                                dw_pe = pe;
                                pe = up_pe;
                                ++n;
lbl99:
                                // 2 sources

                                ** while (n < ps.trace.length)
                            }
lbl100:
                            // 1 sources

                        }
                    }
                    for (ProfileEntry pe : this.entries.values()) {
                        if (pe.up != null) {
                            Arrays.sort(pe.up, new ProfileEntryRefComparator());
                        }
                        if (pe.dw == null) continue;
                        Arrays.sort(pe.dw, new ProfileEntryRefComparator());
                    }
                }
                this.prof_data.generation_out = this.generation;
                this.prof_data.entries = this.entries.values().toArray(new ProfileEntry[this.entries.size()]);
                if (!Update.$assertionsDisabled && this.pending != null) {
                    throw new AssertionError();
                }
            }
            if (this.prof_data != null && this.prof_data.entries != null) {
                Arrays.sort(this.prof_data.entries, new ProfileEntryComparator(this.sorting));
            }
            this.done = true;
            enable_start = capabilities_ok;
            enable_stop = this.node != null && this.prof_data.stopped == false;
            stopped = this.node != null && this.prof_data.stopped != false;
            running = this.node != null && stopped == false;
            unsupported = this.node != null && this.prof_data.unsupported != false;
            total_count = this.prof_data != null && this.prof_data.stack_trace != false;
            sample_count = this.prof_data == null ? 0 : this.prof_data.sample_count;
            error_msg = this.prof_data == null || this.prof_data.error == null ? null : TCFModel.getErrorMessage(this.prof_data.error, false);
            ProfilerView.access$22(ProfilerView.this, new Runnable(){

                @Override
                public void run() {
                    ProfileEntry[] viewer_input;
                    if (ProfilerView.this.last_update != Update.this) {
                        return;
                    }
                    if (ProfilerView.this.parent.isDisposed()) {
                        return;
                    }
                    ProfilerView.this.action_start.setEnabled(enable_start);
                    ProfilerView.this.action_stop.setEnabled(enable_stop);
                    ProfilerView.this.profile_node = Update.this.node;
                    ProfilerView.this.disposeColors();
                    ProfileEntry[] profileEntryArray = viewer_input = Update.this.prof_data != null ? Update.this.prof_data.entries : null;
                    if (ProfilerView.this.viewer_main.getInput() != viewer_input) {
                        ISelection s = ProfilerView.this.viewer_main.getSelection();
                        ProfilerView.this.total_count = total_count;
                        ProfilerView.this.sample_count = sample_count;
                        ProfilerView.this.viewer_main.setInput((Object)viewer_input);
                        ArrayList<ProfileEntry> l = new ArrayList<ProfileEntry>();
                        if (s instanceof IStructuredSelection && Update.this.entries.size() > 0) {
                            IStructuredSelection ss = (IStructuredSelection)s;
                            Object[] objectArray = ss.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object obj = objectArray[n2];
                                if (obj instanceof ProfileEntry) {
                                    ProfileEntry pe = (ProfileEntry)obj;
                                    pe = Update.this.entries.get(pe.addr);
                                    if (pe != null) {
                                        l.add(pe);
                                    }
                                }
                                ++n2;
                            }
                        }
                        ProfilerView.this.setSelection(l, false);
                    } else {
                        ProfilerView.this.viewer_main.refresh();
                    }
                    if (!enable_start) {
                        ProfilerView.this.status.setText("Selected context does not support profiling");
                    } else if (unsupported) {
                        ProfilerView.this.status.setText("No suitable profiler found for selected context");
                    } else if (stopped) {
                        ProfilerView.this.status.setText("Profiler stopped. Press 'Start' button to restart profiling");
                    } else if (!running) {
                        ProfilerView.this.status.setText("Idle. Press 'Start' button to start profiling");
                    } else if (error_msg != null) {
                        ProfilerView.this.status.setText("Cannot upload profiling data: " + error_msg);
                    } else {
                        ProfilerView.this.status.setText("Profiler running. " + sample_count + " samples");
                    }
                }
            });
        }
    }
}

