/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableDelegate;

public class VariableDelegateExtensionPointManager
extends AbstractExtensionPointManager<IVariableDelegate> {
    VariableDelegateExtensionPointManager() {
    }

    public static VariableDelegateExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.persistence.variableDelegates";
    }

    protected String getConfigurationElementName() {
        return "delegate";
    }

    public IVariableDelegate[] getDelegates(IPersistenceDelegate persistenceDelegate) {
        ArrayList<IVariableDelegate> contributions = new ArrayList<IVariableDelegate>();
        Collection delegates = this.getExtensions().values();
        for (ExecutableExtensionProxy delegate : delegates) {
            IVariableDelegate instance;
            String id = delegate.getConfigurationElement().getAttribute("delegateId");
            if (id != null && !id.equals(persistenceDelegate.getId()) || (instance = (IVariableDelegate)delegate.getInstance()) == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new IVariableDelegate[contributions.size()]);
    }

    private static class LazyInstance {
        public static VariableDelegateExtensionPointManager instance = new VariableDelegateExtensionPointManager();

        private LazyInstance() {
        }
    }
}

