/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model;

import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.util.NameUtils;

@NonNullByDefault
public abstract class YamlElementName
implements ElementName {
    public static final byte RESOURCE = 2;
    public static final byte OTHER = 15;
    public static final byte SCALAR = 16;
    public static final byte ANCHOR = 65;
    public static final byte DOC_NUM = 81;
    public static final byte SEQ_NUM = 82;
    public static final byte COMPLEX = 96;

    public static YamlElementName create(int type, @Nullable String name) {
        return new Default(type, name);
    }

    public abstract @Nullable YamlElementName getNextSegment();

    public YamlElementName getLastSegment() {
        YamlElementName lastSegment;
        YamlElementName nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public int hashCode() {
        String name = this.getSegmentName();
        YamlElementName next = this.getNextSegment();
        if (next != null) {
            return this.getType() * (name != null ? name.hashCode() : 1) * (((Object)next).hashCode() + 7);
        }
        return this.getType() * (name != null ? name.hashCode() : 1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof YamlElementName)) break block3;
                YamlElementName yamlElementName = (YamlElementName)object;
                YamlElementName cfr_ignored_0 = (YamlElementName)object;
                if (this.getType() == other.getType() && NameUtils.areEqual((String)this.getSegmentName(), (String)other.getSegmentName()) && Objects.equals(this.getNextSegment(), other.getNextSegment())) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class Default
    extends YamlElementName {
        protected final int type;
        protected final @Nullable String segment;

        private Default(int type, @Nullable String name) {
            this.type = type;
            this.segment = name;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public @Nullable YamlElementName getNextSegment() {
            return null;
        }

        public @Nullable String getSegmentName() {
            return this.segment;
        }

        public String getDisplayName() {
            return switch (this.type) {
                case 82 -> "#" + this.segment;
                case 16 -> {
                    if (this.segment != null) {
                        yield this.segment;
                    }
                    yield "<null>";
                }
                default -> this.segment != null ? this.segment : "<missing>";
            };
        }
    }
}

