/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstInfo;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxIssueReporter;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitModelContainer;
import org.eclipse.statet.docmlet.tex.core.parser.NowebLtxLexer;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.docmlet.tex.core.project.TexProjects;
import org.eclipse.statet.docmlet.tex.core.source.TexSourceConfig;
import org.eclipse.statet.internal.docmlet.tex.core.TexCorePlugin;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxModelManagerImpl;
import org.eclipse.statet.internal.docmlet.tex.core.model.SourceAnalyzer;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.CacheStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.build.ExtensibleReconciler;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.ltk.project.core.LtkProject;

@NonNullByDefault
public class LtxReconciler
extends ExtensibleReconciler<TexProject, LtxSourceUnitModelContainer<?>, LtxSourceUnitEmbeddedModelReconciler<?>> {
    private static final ImIdentityList<String> DEFAULT_EMBEDDED_MODEL_IDS = ImCollections.newIdentityList();
    private static final boolean DEBUG_LOG_AST = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.docmlet.tex/debug/Reconciler/logAst"));
    private final LtxModelManagerImpl texManager;
    private final Object raLock = new Object();
    private final StringParserInput raInput = new StringParserInput(4096);
    private final NowebLtxLexer raLexer = new NowebLtxLexer();
    private final LtxParser raParser = new LtxParser(this.raLexer, (StringFactory)new CacheStringFactory(32));
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmSourceAnalyzer = new SourceAnalyzer();
    private final Object riLock = new Object();
    private final LtxIssueReporter riReporter = new LtxIssueReporter();

    public LtxReconciler(LtxModelManagerImpl manager) {
        this.texManager = manager;
    }

    public void init(TexProject project, MultiStatus statusCollector) {
        super.init((LtkProject)project, statusCollector);
        this.riReporter.configure(project.getPrefs(), project);
    }

    void stop() {
        this.stop = true;
    }

    protected @Nullable TexProject getProject(IProject project) {
        return TexProjects.getTexProject(project);
    }

    protected @Nullable LtxSourceUnitEmbeddedModelReconciler<?> createEmbeddedModelReconciler(String modelTypeId) {
        return (LtxSourceUnitEmbeddedModelReconciler)LtkModels.getModelAdapter((String)modelTypeId, LtxSourceUnitEmbeddedModelReconciler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(LtxSourceUnitModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        Data data;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        ImIdentityList embeddedModelIds = DEFAULT_EMBEDDED_MODEL_IDS;
        String nowebTypeId = adapter.getNowebType();
        if (nowebTypeId != null) {
            embeddedModelIds = ImCollections.addElementIfAbsent(embeddedModelIds, (Object)nowebTypeId);
        }
        ImList extensions = this.initExtensions((ImCollection)embeddedModelIds, adapter, flags);
        if (nowebTypeId != null && !ExtensibleReconciler.ExtensionData.contains((ImList)extensions, (String)nowebTypeId)) {
            nowebTypeId = null;
        }
        if ((data = new Data(adapter, extensions, nowebTypeId, m)) == null || !data.isOK()) {
            adapter.clear();
            return;
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            this.updateAst(data, flags, m);
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        if ((flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            boolean updated = this.updateModel(data, flags, m);
            if (updated) {
                this.texManager.getEventJob().addUpdate((LtkModelElement)data.sourceUnit, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            object = this.riLock;
            synchronized (object) {
                if (this.stop || m.isCanceled() || data.newModel != data.adapter.getCurrentModel()) {
                    return;
                }
                this.reportIssues(data, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, SubMonitor m) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp(), this.createSourceConfig(TexSourceConfig.DEFAULT_CONFIG, data.extensions));
        TexAstInfo ast = (TexAstInfo)data.adapter.getCurrentAst();
        if (ast != null && !stamp.equals(ast.getStamp())) {
            ast = null;
        }
        if (ast != null) {
            data.ast = ast;
        } else {
            Object embeddedNodes;
            SourceComponent sourceNode;
            this.raInput.reset(data.content.getString());
            this.raParser.setCommentLevel(1);
            if (data.nowebTypeId != null) {
                ExtensibleReconciler.ExtensionData extensionData = (ExtensibleReconciler.ExtensionData)ObjectUtils.nonNullAssert((Object)ExtensibleReconciler.ExtensionData.get(data.extensions, (String)data.nowebTypeId));
                this.raLexer.setNowebType(extensionData.modelTypeId);
                this.raParser.setCollectEmebeddedNodes(true);
                sourceNode = this.raParser.parseSourceUnit((TextParserInput)this.raInput.init(), data.texCoreAccess.getTexCommandSet());
                data.customCommands = this.raParser.getCustomCommandMap();
                data.customEnvs = this.raParser.getCustomEnvMap();
                embeddedNodes = this.raParser.getEmbeddedNodes();
            } else {
                this.raLexer.setNowebType(null);
                this.raParser.setCollectEmebeddedNodes(false);
                sourceNode = this.raParser.parseSourceUnit((TextParserInput)this.raInput.init(), data.texCoreAccess.getTexCommandSet());
                embeddedNodes = ImCollections.emptyList();
            }
            ImIdentitySet embeddedTypeIds = this.collectEmbeddedTypeIds((List)embeddedNodes);
            for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
                if (!embeddedTypeIds.contains((Object)extensionData.modelTypeId)) continue;
                ((LtxSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reconcileAst(data.content, (List<Embedded>)embeddedNodes, data.adapter, extensionData.config, flags);
            }
            ast = new TexAstInfo(1, (SourceModelStamp)stamp, sourceNode, (ImIdentitySet<String>)embeddedTypeIds);
            if (DEBUG_LOG_AST) {
                this.logAst(ast, data.content);
            }
            LtxSourceUnitModelContainer<?> ltxSourceUnitModelContainer = data.adapter;
            synchronized (ltxSourceUnitModelContainer) {
                data.adapter.setAst(ast);
            }
            data.ast = ast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, SubMonitor m) {
        LtxSourceUnitModelInfo model = (LtxSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (model != null && !data.getAst().getStamp().equals(model.getStamp())) {
            model = null;
        }
        if (model != null) {
            data.newModel = model;
            return false;
        }
        model = this.rmSourceAnalyzer.createModel((TexSourceUnit)data.adapter.getSourceUnit(), data.content.getString(), data.getAst(), data.customCommands, data.customEnvs);
        boolean isOK = model != null;
        for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
            ((LtxSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reconcileModel(model, data.content, this.rmSourceAnalyzer.getEmbeddedItems(), data.adapter, extensionData.config, flags, m);
        }
        if (isOK) {
            LtxSourceUnitModelContainer<?> ltxSourceUnitModelContainer = data.adapter;
            synchronized (ltxSourceUnitModelContainer) {
                data.oldModel = (LtxSourceUnitModelInfo)data.adapter.getCurrentModel();
                data.adapter.setModel(model);
            }
            data.newModel = model;
            return true;
        }
        return false;
    }

    protected final void reportIssues(Data data, int flags) {
        block7: {
            try {
                SourceUnitIssueSupport issueSupport = data.adapter.getIssueSupport();
                if (issueSupport == null) {
                    return;
                }
                IssueRequestor issueRequestor = issueSupport.createIssueRequestor((SourceUnit)data.sourceUnit);
                if (issueRequestor == null) break block7;
                try {
                    this.riReporter.run(data.sourceUnit, data.getModel(), data.content, issueRequestor, flags);
                    for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
                        ((LtxSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reportIssues(data.getModel(), data.content, issueRequestor, data.adapter, extensionData.config, flags);
                    }
                }
                finally {
                    issueRequestor.finish();
                }
            }
            catch (Exception e) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", 0, String.format("An error occurred when reporting issues for source unit %1$s.", data.sourceUnit), (Throwable)e));
            }
        }
    }

    protected void handleStatus(IStatus status) {
        MultiStatus collector = this.getStatusCollector();
        if (collector != null) {
            collector.add(status);
        } else {
            TexCorePlugin.log(status);
        }
    }

    protected static class Data {
        public final LtxSourceUnitModelContainer<?> adapter;
        public final ImList<ExtensibleReconciler.ExtensionData<TexProject, ?, LtxSourceUnitEmbeddedModelReconciler<?>>> extensions;
        public final @Nullable String nowebTypeId;
        public final TexSourceUnit sourceUnit;
        public final TexCoreAccess texCoreAccess;
        public final SourceContent content;
        @Nullable TexAstInfo ast;
        @Nullable Map<String, TexCommand> customCommands;
        @Nullable Map<String, TexCommand> customEnvs;
        @Nullable LtxSourceUnitModelInfo oldModel;
        @Nullable LtxSourceUnitModelInfo newModel;

        public Data(LtxSourceUnitModelContainer<?> adapter, ImList<ExtensibleReconciler.ExtensionData<TexProject, ?, LtxSourceUnitEmbeddedModelReconciler<?>>> extensions, @Nullable String nowebTypeId, SubMonitor m) {
            this.adapter = adapter;
            this.extensions = extensions;
            this.nowebTypeId = nowebTypeId;
            this.sourceUnit = (TexSourceUnit)adapter.getSourceUnit();
            this.texCoreAccess = TexCore.getContextAccess((IAdaptable)adapter.getSourceUnit());
            this.content = adapter.getParseContent((IProgressMonitor)m);
        }

        boolean isOK() {
            return this.content != null;
        }

        public TexAstInfo getAst() {
            return this.ast;
        }

        public LtxSourceUnitModelInfo getModel() {
            return this.newModel;
        }
    }
}

