/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.ParseHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialStyleDelimiter;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialStyleDelimiterInfo;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Strikeout;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Subscript;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Superscript;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class PotentialStyleSpan
extends SourceSpan {
    private final @Nullable PotentialStyleDelimiterInfo tilde;
    private final @Nullable PotentialStyleDelimiterInfo circumflex;

    private static char charAfter(Cursor cursor, int length) {
        return cursor.hasNext(length) ? cursor.getNext(length) : (char)'\n';
    }

    private static char charBefore(Cursor cursor) {
        return cursor.hasPrevious() ? (char)cursor.getPrevious() : (char)'\n';
    }

    public PotentialStyleSpan() {
        this.tilde = null;
        this.circumflex = null;
    }

    public PotentialStyleSpan(boolean strikeoutEnabled, boolean superscriptEnabled, boolean subscriptEnabled) {
        this.tilde = strikeoutEnabled || subscriptEnabled ? new PotentialStyleDelimiterInfo.ExtDelimiter(subscriptEnabled, strikeoutEnabled){

            @Override
            public char getChar() {
                return '~';
            }

            @Override
            public Inline createStyleInline(int size, Line line, int offset, int length, List<Inline> contents) {
                switch (size) {
                    case 1: {
                        return new Subscript(line, offset, length, contents);
                    }
                    case 2: {
                        return new Strikeout(line, offset, length, contents);
                    }
                }
                throw new IllegalStateException();
            }
        } : null;
        this.circumflex = superscriptEnabled ? new PotentialStyleDelimiterInfo.ExtDelimiter(superscriptEnabled, false){

            @Override
            public char getChar() {
                return '^';
            }

            @Override
            public Inline createStyleInline(int size, Line line, int offset, int length, List<Inline> contents) {
                switch (size) {
                    case 1: {
                        return new Superscript(line, offset, length, contents);
                    }
                }
                throw new IllegalStateException();
            }
        } : null;
    }

    public String getControlChars() {
        if (this.tilde != null) {
            if (this.circumflex != null) {
                return "*^_~";
            }
            return "*_~";
        }
        if (this.circumflex != null) {
            return "*^_";
        }
        return "*_";
    }

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        int length;
        PotentialStyleDelimiterInfo info = this.getInfo(cursor.getChar());
        if (info != null && !this.currentPositionIsEscaped(cursor) && info.isPotentialSequence(length = this.lengthMatching(cursor, info.getChar()))) {
            boolean canOpen = true;
            boolean canClose = true;
            if ((info.getRequirements(0) & 3) != 0) {
                boolean leftFlanking = this.isLeftFlanking(cursor, length, context);
                boolean rightFlanking = this.isRightFlanking(cursor, length, context);
                if ((info.getRequirements(0) & 2) != 0) {
                    ParseHelper helper = context.getHelper();
                    canOpen = leftFlanking && (!rightFlanking || helper.isUnicodePunctuation(PotentialStyleSpan.charBefore(cursor)));
                    canClose = rightFlanking && (!leftFlanking || helper.isUnicodePunctuation(PotentialStyleSpan.charAfter(cursor, length)));
                } else {
                    canOpen = leftFlanking;
                    canClose = rightFlanking;
                }
            }
            return new PotentialStyleDelimiter(info, cursor.getLineAtOffset(), cursor.getOffset(), length, cursor.getTextAtOffset(0, length), canOpen, canClose);
        }
        return null;
    }

    private @Nullable PotentialStyleDelimiterInfo getInfo(char c) {
        switch (c) {
            case '*': {
                return PotentialStyleDelimiterInfo.DEFAULT_ASTERISK;
            }
            case '_': {
                return PotentialStyleDelimiterInfo.DEFAULT_UNDERSCORE;
            }
            case '~': {
                return this.tilde;
            }
            case '^': {
                return this.circumflex;
            }
        }
        return null;
    }

    boolean isLeftFlanking(Cursor cursor, int length, ProcessingContext context) {
        char charBefore = PotentialStyleSpan.charBefore(cursor);
        char charAfter = PotentialStyleSpan.charAfter(cursor, length);
        ParseHelper helper = context.getHelper();
        return !CommonRegex.isUnicodeWhitespace(charAfter) && (!helper.isUnicodePunctuation(charAfter) || CommonRegex.isUnicodeWhitespace(charBefore) || helper.isUnicodePunctuation(charBefore));
    }

    boolean isRightFlanking(Cursor cursor, int length, ProcessingContext context) {
        char charBefore = PotentialStyleSpan.charBefore(cursor);
        char charAfter = PotentialStyleSpan.charAfter(cursor, length);
        ParseHelper helper = context.getHelper();
        return !CommonRegex.isUnicodeWhitespace(charBefore) && (!helper.isUnicodePunctuation(charBefore) || CommonRegex.isUnicodeWhitespace(charAfter) || helper.isUnicodePunctuation(charAfter));
    }

    private boolean currentPositionIsEscaped(Cursor cursor) {
        int backslashCount = 0;
        int x = 1;
        while (cursor.hasPrevious(x) && cursor.getPrevious(x) == '\\') {
            ++backslashCount;
            ++x;
        }
        return backslashCount % 2 == 1;
    }

    private int lengthMatching(Cursor cursor, char c) {
        int x = 1;
        while (cursor.hasNext(x) && cursor.getNext(x) == c) {
            ++x;
        }
        return x;
    }
}

