/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.core;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.statet.ecommons.net.ssh.core.ISshSessionService;
import org.eclipse.statet.internal.ide.core.BaseCorePlugin;
import org.eclipse.statet.jcommons.lang.Disposable;

public class SshSessionManager
implements ISshSessionService,
Disposable {
    private static final int SSH_TIMEOUT = 60000;
    private Map<String, Session> fPool = new HashMap<String, Session>();

    public Session getSshSession(String username, String host, int port, IProgressMonitor monitor) throws CoreException {
        String key = String.valueOf(username) + '@' + host + ':' + Integer.toString(port > 0 ? port : 22);
        Session session = this.fPool.get(key);
        try {
            IJSchService jschService = BaseCorePlugin.getInstance().getJSchService();
            if (session == null) {
                IJSchLocation location = jschService.getLocation(username, host, port);
                session = jschService.createSession(location, null);
            }
            if (!session.isConnected()) {
                jschService.connect(session, 60000, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.fPool.put(key, session);
            return session;
        }
        catch (JSchException e) {
            if ("Packet corrupt".equals(e.getMessage()) && this.fPool.values().remove(session)) {
                return this.getSshSession(username, host, port, monitor);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ide.core", "Failed to create SSH connection", (Throwable)e));
        }
    }

    public void dispose() {
        Collection<Session> sessions = this.fPool.values();
        for (Session session : sessions) {
            session.disconnect();
        }
        this.fPool = null;
    }
}

