/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.painter.cell.ImagePainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class CheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image uncheckedImg;

    public CheckBoxPainter() {
        this.checkedImg = GUIHelper.getImage("checked");
        this.uncheckedImg = GUIHelper.getImage("unchecked");
    }

    public CheckBoxPainter(Image checkedImg, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.uncheckedImg = uncheckedImg;
    }

    public long getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public long getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    @Override
    protected Image getImage(LayerCell cell, ConfigRegistry configRegistry) {
        return this.isChecked(cell, configRegistry) ? this.checkedImg : this.uncheckedImg;
    }

    protected boolean isChecked(LayerCell cell, ConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(LayerCell cell, ConfigRegistry configRegistry) {
        if (cell.getDataValue(0, null) instanceof Boolean) {
            return (Boolean)cell.getDataValue(0, null);
        }
        IDisplayConverter displayConverter = configRegistry.getAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getLabels().getLabels());
        Boolean convertedValue = null;
        if (displayConverter != null) {
            convertedValue = (Boolean)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue(0, null));
        }
        if (convertedValue == null) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }
}

