/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.edit.ICellEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectRelativeCellCommand;

public class InlineEditHandler
implements ICellEditHandler {
    private final Layer layer;
    private final long columnPosition;
    private final long rowPosition;

    public InlineEditHandler(Layer layer, long columnPosition, long rowPosition) {
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    @Override
    public boolean commit(Object canonicalValue, Direction direction) {
        boolean committed = this.layer.doCommand(new UpdateDataCommand(this.layer, this.columnPosition, this.rowPosition, canonicalValue));
        if (committed) {
            switch (direction) {
                case LEFT: {
                    this.layer.doCommand(new SelectRelativeCellCommand(Direction.LEFT));
                    break;
                }
                case UP: {
                    this.layer.doCommand(new SelectRelativeCellCommand(Direction.UP));
                    break;
                }
                case RIGHT: {
                    this.layer.doCommand(new SelectRelativeCellCommand(Direction.RIGHT));
                    break;
                }
                case DOWN: {
                    this.layer.doCommand(new SelectRelativeCellCommand(Direction.DOWN));
                }
            }
        }
        return committed;
    }
}

