/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RLangMethod;

@NonNullByDefault
public class RFunctionValue
extends RElementVariableValue<CombinedRElement> {
    public RFunctionValue(BasicRElementVariable variable) {
        super(variable);
    }

    @Override
    public String getValueString() throws DebugException {
        if (this.element instanceof RLangMethod) {
            RLangMethod lang = (RLangMethod)this.element;
            StringBuilder sb = new StringBuilder();
            Parameters params = lang.getParameters();
            sb.append("function(");
            if (params == null) {
                sb.append("<unknown>");
            } else if (params.size() > 0) {
                this.append(sb, params.get(0));
                int i = 1;
                while (i < params.size()) {
                    sb.append(", ");
                    this.append(sb, params.get(i));
                    ++i;
                }
            }
            sb.append(")");
            return sb.toString();
        }
        return super.getValueString();
    }

    private void append(StringBuilder sb, Parameters.Parameter parameter) {
        String name = parameter.getName();
        if (name != null) {
            sb.append(name);
        }
    }
}

