/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class WidgetUtils {
    public static @Nullable Display getDisplay(@Nullable Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            try {
                return widget.getDisplay();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setSelection(StyledText styledText, int start, int end, int time) {
        Point prevSelection = styledText.getSelection();
        styledText.setSelection(start, end);
        Point newSelection = styledText.getSelection();
        if (!newSelection.equals((Object)prevSelection)) {
            Event event = new Event();
            event.display = styledText.getDisplay();
            event.widget = styledText;
            event.type = 13;
            event.time = time;
            event.x = newSelection.x;
            event.y = newSelection.y;
            styledText.notifyListeners(13, event);
        }
    }

    public static void setSelection(StyledText styledText, int offset, int time) {
        WidgetUtils.setSelection(styledText, offset, offset, time);
    }

    private WidgetUtils() {
    }
}

