/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlLabelAccess;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;

public class LabelAccess
extends YamlLabelAccess {
    public static final int A_READ = 0;
    public static final int A_WRITE = 2;
    private final Shared shared;
    private final YamlAstNode node;
    private final YamlAstNode nameNode;
    int flags;

    protected LabelAccess(Shared shared, YamlAstNode node, YamlAstNode labelNode) {
        this.shared = shared;
        shared.all.add(this);
        this.node = node;
        this.nameNode = labelNode;
    }

    public int getType() {
        return 65;
    }

    public String getSegmentName() {
        return this.shared.label;
    }

    public String getDisplayName() {
        return this.shared.label;
    }

    @Override
    public YamlElementName getNextSegment() {
        return null;
    }

    @Override
    public YamlAstNode getNode() {
        return this.node;
    }

    @Override
    public YamlAstNode getNameNode() {
        return this.nameNode;
    }

    @Override
    public List<? extends YamlLabelAccess> getAllInUnit() {
        return this.shared.all;
    }

    @Override
    public boolean isWriteAccess() {
        return (this.flags & 2) != 0;
    }

    static class Shared {
        private final String label;
        private List<YamlLabelAccess> all;

        public Shared(String label) {
            this.label = label;
            this.all = new ArrayList<YamlLabelAccess>(8);
        }

        public void finish() {
            this.all = ImCollections.toList(this.all);
        }

        public List<YamlLabelAccess> getAll() {
            return this.all;
        }
    }
}

