/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayList;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImArraySet<E>
extends AbstractImList<E>
implements ImSet<E>,
RandomAccess {
    private final E[] array;

    public ImArraySet(E[] a) {
        this.array = a;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.indexOf(e.next()) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null) {
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] == null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < this.array.length) {
            if (o.equals(this.array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o == null) {
            int i = this.array.length - 1;
            while (i >= 0) {
                if (this.array[i] == null) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        int i = this.array.length - 1;
        while (i >= 0) {
            if (o.equals(this.array[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, 0, this.array.length, 1025);
    }

    @Override
    public Object[] toArray() {
        Object[] dest = new Object[this.array.length];
        System.arraycopy(this.array, 0, dest, 0, this.array.length);
        return dest;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        int n = this.array.length;
        if (dest.length < n) {
            return Arrays.copyOf(this.array, n, dest.getClass());
        }
        System.arraycopy(this.array, 0, dest, 0, n);
        if (dest.length > n) {
            dest[n] = null;
        }
        return dest;
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
        System.arraycopy(this.array, 0, dest, destPos, this.array.length);
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(this.array, srcPos, dest, destPos, length);
    }

    @Override
    public ImList<E> toList() {
        return new ImArrayList<E>(this.array);
    }

    @Override
    public ImIdentityList<E> toIdentityList() {
        return new ImArrayIdentityList<E>(this.array);
    }

    @Override
    public <R> ImCollection.MappingResult<R> map(Function<E, R> mapper) {
        Object[] result = new Object[this.array.length];
        int i = 0;
        while (i < this.array.length) {
            result[i] = mapper.apply(this.array[i]);
            ++i;
        }
        return new ImArrayList<Object>(result);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] != null) {
                hashCode += this.array[i].hashCode();
            }
            ++i;
        }
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Set) {
            Set other = (Set)obj;
            return this.array.length == other.size() && this.containsAll(other);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    private class Iter
    extends AbstractImList.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImArraySet.this.array.length;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= ImArraySet.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImArraySet.this.array[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0 || ImArraySet.this.array.length <= 0) {
                throw new NoSuchElementException();
            }
            return ImArraySet.this.array[--this.cursor];
        }
    }
}

