/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacterFix64Store;
import org.eclipse.statet.rj.data.impl.RListFix64Impl;

@NonNullByDefault
public class RDataFrameFix64Impl
extends RListFix64Impl
implements RDataFrame,
ExternalizableRObject {
    private final @Nullable RStore<?> rownamesAttribute;
    private final long rowCount;

    public RDataFrameFix64Impl(RObject[][] columns, String className1, @Nullable String @Nullable [][] initialNames, @NonNull String[] @NonNull [] initialRownames) {
        this(columns, className1, initialNames, initialRownames, true);
    }

    protected RDataFrameFix64Impl(RObject[][] columns, String className1, @Nullable String @Nullable [][] initialNames, @NonNull String @Nullable [] @NonNull [] initialRownames, boolean check) {
        super(columns, className1, initialNames);
        if (columns.length == 0) {
            this.rowCount = 0L;
        } else {
            this.rowCount = columns[0][0].getLength();
            if (check) {
                int i = 0;
                while (i < columns.length) {
                    RObject[] segment = columns[i];
                    int j = 0;
                    while (j < segment.length) {
                        if (segment[j].getRObjectType() != 2 || segment[j].getLength() != this.rowCount) {
                            throw new IllegalArgumentException("Length of column " + ((long)i * 0x10000000L + (long)j) + ": " + segment[j].getLength());
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (initialRownames != null) {
            this.rownamesAttribute = new RCharacterFix64Store(initialRownames);
            if (this.rownamesAttribute.getLength() != this.rowCount) {
                throw new IllegalArgumentException("Length of row names: " + this.rownamesAttribute.getLength());
            }
        } else {
            this.rownamesAttribute = null;
        }
    }

    public RDataFrameFix64Impl(RJIO io, RObjectFactory factory, int options) throws IOException {
        super(io, factory, options);
        this.rowCount = io.readLong();
        this.rownamesAttribute = (options & 0x40) != 0 ? factory.readNames(io, this.rowCount) : null;
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = 0;
        if ((io.flags & 1) == 0 && this.rownamesAttribute != null) {
            options |= 0x40;
        }
        super.doWriteExternal(io, options, factory);
        io.writeLong(this.rowCount);
        if ((options & 0x40) != 0) {
            factory.writeNames(this.rownamesAttribute, io);
        }
    }

    @Override
    public byte getRObjectType() {
        return 6;
    }

    @Override
    protected String getDefaultRClassName() {
        return "data.frame";
    }

    @Override
    public long getColumnCount() {
        return this.getLength();
    }

    @Override
    public RCharacterStore getColumnNames() {
        return this.getNames();
    }

    public String getColumnName(int idx) {
        return this.getName(idx);
    }

    @Override
    public RStore<?> getColumn(int idx) {
        RObject obj = this.get(idx);
        return obj != null ? obj.getData() : null;
    }

    @Override
    public RStore<?> getColumn(long idx) {
        RObject obj = this.get(idx);
        return obj != null ? obj.getData() : null;
    }

    @Override
    public @Nullable RStore<?> getColumn(String name) {
        RObject obj = this.get(name);
        return obj != null ? obj.getData() : null;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public @Nullable RStore<?> getRowNames() {
        return this.rownamesAttribute;
    }
}

