/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.ui.config.MarkupConfigUIAdapter;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.docmlet.wikitext.ui.config.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
class MarkupConfigurationBlock
extends ManagedConfigurationBlock {
    private WikitextMarkupLanguageManager1 markupLanguageManager;
    private List<MarkupEntry> markupEntries;
    private TableViewer markupEntriesControl;
    private ButtonGroup<MarkupEntry> markupEntriesButtons;

    public MarkupConfigurationBlock(@Nullable IProject project, @Nullable StatusChangeListener statusListener) {
        super(project, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        this.markupLanguageManager = WikitextCore.getMarkupLanguageManager();
        HashMap<Preference<String>, @Nullable Object> prefs = new HashMap<Preference<String>, Object>();
        ImList languageNames = this.markupLanguageManager.getLanguageNames();
        this.markupEntries = new ArrayList<MarkupEntry>(languageNames.size());
        for (String languageName : languageNames) {
            WikitextMarkupLanguageManager.WikitextMarkupLanguageDescriptor languageDescriptor = this.markupLanguageManager.getLanguageDescriptor(languageName);
            if (!languageDescriptor.isConfigSupported() || languageDescriptor.getPreferenceQualifier() == null) continue;
            MarkupEntry entry = new MarkupEntry(languageDescriptor);
            this.markupEntries.add(entry);
            prefs.put(entry.getPref(), null);
        }
        this.setupPreferenceManager(prefs);
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(mainComposite, 16384);
        label.setText(Messages.MarkupConfigs_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        TableViewer viewer = new TableViewer(mainComposite);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(@Nullable Object element) {
                if (element instanceof MarkupEntry) {
                    return ((MarkupEntry)element).getLabel();
                }
                return super.getText(element);
            }
        });
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.markupEntriesControl = viewer;
        ButtonGroup buttons = new ButtonGroup(mainComposite);
        buttons.addEditButton(new ButtonGroup.SelectionHandler(){

            public boolean run(IStructuredSelection selection) {
                Object element = this.getElement(selection);
                if (element instanceof MarkupEntry) {
                    MarkupConfigurationBlock.this.edit((MarkupEntry)element);
                    return true;
                }
                return false;
            }
        });
        buttons.connectTo((StructuredViewer)this.markupEntriesControl, null);
        buttons.setLayoutData((Object)new GridData(4, 128, false, true));
        this.markupEntriesButtons = buttons;
        this.initBindings();
        this.updateControls();
    }

    protected void addBindings(DataBindingSupport db) {
        this.markupEntriesControl.setInput(this.markupEntries);
    }

    protected void updateControls() {
        super.updateControls();
        ViewerUtils.scheduleStandardSelection((TableViewer)this.markupEntriesControl);
    }

    private void edit(MarkupEntry entry) {
        MarkupConfig config = entry.getDescriptor().newConfig();
        if (config != null) {
            MarkupConfigUIAdapter ui;
            String configString = (String)this.getPreferenceValue(entry.getPref());
            if (configString != null) {
                config.load(configString);
            }
            if ((ui = (MarkupConfigUIAdapter)Platform.getAdapterManager().loadAdapter((Object)config, MarkupConfigUIAdapter.class.getName())) != null) {
                if (ui.edit(null, null, config, this.getShell())) {
                    String configString2 = config.getString();
                    this.setPrefValue(entry.getPref(), configString2);
                }
                return;
            }
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.MarkupConfig_title, (String)NLS.bind((String)"Sorry, the configuration of {0} is not supported.", (Object)entry.getDescriptor().getName()));
        this.markupEntriesControl.remove((Object)entry);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.MarkupConfig_NeedsBuild_title;
        String message = workspaceSettings ? Messages.MarkupConfig_NeedsFullBuild_message : Messages.MarkupConfig_NeedsProjectBuild_message;
        return new String[]{title, message};
    }

    private class MarkupEntry {
        private final WikitextMarkupLanguageManager.WikitextMarkupLanguageDescriptor descriptor;
        private final Preference<@Nullable String> pref;

        public MarkupEntry(WikitextMarkupLanguageManager.WikitextMarkupLanguageDescriptor descriptor) {
            this.descriptor = descriptor;
            this.pref = new Preference.NullableStringPref(descriptor.getPreferenceQualifier(), "MarkupConfig.Workbench.config");
        }

        public WikitextMarkupLanguageManager.WikitextMarkupLanguageDescriptor getDescriptor() {
            return this.descriptor;
        }

        public String getLabel() {
            return this.descriptor.getLabel();
        }

        public Preference<@Nullable String> getPref() {
            return this.pref;
        }
    }
}

