/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;

@NonNullByDefault
public class REnvUtils {
    public static String encode(@Nullable REnv rEnv) {
        if (rEnv != null) {
            String name = rEnv.getName();
            if (name != null && !rEnv.getId().startsWith("default-")) {
                return String.valueOf(rEnv.getId()) + ';' + name;
            }
            return String.valueOf(rEnv.getId()) + ';';
        }
        return "";
    }

    public static @Nullable REnv decode(@Nullable String encodedSetting, REnvManager manager) {
        int idx;
        REnv rEnv;
        if (encodedSetting != null && (rEnv = (idx = encodedSetting.indexOf(59)) >= 0 ? manager.get(encodedSetting.substring(0, idx), encodedSetting.substring(idx + 1)) : manager.get(encodedSetting, null)) != null) {
            return rEnv;
        }
        return null;
    }

    public static @Nullable String standardizePathString(@Nullable String pathString) {
        if (pathString == null || pathString.isEmpty()) {
            return null;
        }
        int i = 0;
        int sep = 0;
        block7: while (i < pathString.length()) {
            char c = pathString.charAt(i++);
            switch (c) {
                case '/': {
                    if (++sep <= 1) continue block7;
                    break block7;
                }
                case '\\': {
                    ++sep;
                    break block7;
                }
                default: {
                    sep = 0;
                }
            }
        }
        if (sep == 0) {
            return pathString;
        }
        StringBuilder sb = new StringBuilder(pathString.length());
        sb.append(pathString, 0, i - sep);
        while (i < pathString.length()) {
            char c = pathString.charAt(i++);
            switch (c) {
                case '/': 
                case '\\': {
                    ++sep;
                    break;
                }
                default: {
                    if (sep != 0) {
                        sb.append('/');
                        sep = 0;
                    }
                    sb.append(c);
                }
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static Comparator<REnv> getComparator(Locale locale) {
        return new Comparator<REnv>(locale){
            final Collator collator;
            {
                this.collator = Collator.getInstance(locale);
            }

            @Override
            public int compare(REnv o1, REnv o2) {
                int r = this.collator.compare(o1.getName(), o2.getName());
                if (r == 0) {
                    r = o1.getId().compareTo(o2.getId());
                }
                return r;
            }
        };
    }

    private REnvUtils() {
    }
}

