/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.node;

import java.util.List;
import org.eclipse.statet.internal.rj.servi.LocalNodeFactory;
import org.eclipse.statet.internal.rj.servi.LocalNodeManager;
import org.eclipse.statet.internal.rj.servi.PoolManager;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.servi.RServiUtils;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.node.RServiNodeManager;
import org.eclipse.statet.rj.servi.pool.RServiPoolManager;

@NonNullByDefault
public class RServiImpl {
    private static final ImList<BundleSpec> LIB_SPECS = ImCollections.addElement((List)ServerUtils.MIN_CLASSPATH_SPECS, (int)0, (Object)RServiUtils.RJ_SERVI_SPEC);

    public static RServiNodeFactory createLocalNodeFactory(String poolId, RJContext context) throws RjInvalidConfigurationException {
        ImList<BundleSpec> libIds = LIB_SPECS;
        try {
            context.resolveBundles(libIds);
        }
        catch (StatusException e) {
            throw new RjInvalidConfigurationException("Failed to resolve the bundle(s) required for RServi nodes.", (Throwable)e);
        }
        return new LocalNodeFactory(poolId, context, (List<BundleSpec>)libIds);
    }

    public static RServiPoolManager createPool(String poolId, RMIRegistry registry) {
        return new PoolManager(poolId, registry);
    }

    public static RServiNodeManager createNodeManager(String id, RMIRegistry registry, RServiNodeFactory factory) {
        if (factory instanceof LocalNodeFactory) {
            return new LocalNodeManager(id, registry, (LocalNodeFactory)factory);
        }
        throw new UnsupportedOperationException(factory.getClass().getName());
    }
}

