/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.codegeneration;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.templates.TemplateMessages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.r.codegeneration.RCodeTemplateContext;
import org.eclipse.statet.r.codegeneration.RdCodeTemplateContext;
import org.eclipse.statet.r.core.BasicRResourceSourceUnit;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RLangClass;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RLangSlot;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;

public class CodeGeneration {
    public static TemplateUtils.EvaluatedTemplate getNewRFileContent(RSourceUnit su, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        block4: {
            Template template = RUIPlugin.getInstance().getRCodeGenerationTemplateStore().findTemplate("r_NewRScriptFile");
            if (template == null) {
                return null;
            }
            RCodeTemplateContext context = new RCodeTemplateContext("r_NewRScriptFile_context", (SourceUnit)su, lineDelimiter);
            try {
                buffer = context.evaluate(template);
                if (buffer != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
            }
        }
        return new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
    }

    public static TemplateUtils.EvaluatedTemplate getCommonFunctionRoxygenComment(RLangMethod rMethod, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        Template template;
        block10: {
            template = RUIPlugin.getInstance().getRCodeGenerationTemplateStore().findTemplate("roxygen_CommonFunctionDef");
            if (template == null) {
                return null;
            }
            SourceUnit su = rMethod.getSourceUnit();
            RCodeTemplateContext context = new RCodeTemplateContext("roxygen_CommonFunctionDef_context", su, lineDelimiter);
            context.setRElement((RElement)rMethod);
            buffer = context.evaluate(template);
            if (buffer != null) break block10;
            return null;
        }
        try {
            TemplateUtils.EvaluatedTemplate data = new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
            AbstractDocument content = data.startPostEdit();
            StringBuilder tagBuffer = new StringBuilder(64);
            TemplateVariable paramVariable = TemplateUtils.findVariable((TemplateBuffer)buffer, (String)"param_tags");
            Position[] paramPositions = new Position[paramVariable != null ? paramVariable.getOffsets().length : 0];
            int i = 0;
            while (i < paramPositions.length) {
                paramPositions[i] = new Position(paramVariable.getOffsets()[i], paramVariable.getLength());
                content.addPosition(paramPositions[i]);
                ++i;
            }
            if (paramPositions.length > 0) {
                String[] tags = null;
                Parameters parameters = rMethod.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    tags = new String[count];
                    int i2 = 0;
                    while (i2 < count) {
                        String paramName = parameters.get(i2).getName();
                        tagBuffer.append("@param ");
                        if (paramName != null) {
                            tagBuffer.append(paramName);
                        }
                        tagBuffer.append(" ");
                        tags[i2] = tagBuffer.toString();
                        tagBuffer.setLength(0);
                        ++i2;
                    }
                }
                Position[] positionArray = paramPositions;
                int n = paramPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    Position pos = positionArray[n2];
                    CodeGeneration.insertRoxygen(content, pos, tags);
                    ++n2;
                }
            }
            data.finishPostEdit();
            return data;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
        }
    }

    public static TemplateUtils.EvaluatedTemplate getClassRoxygenComment(RLangClass rClass, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        Template template;
        block8: {
            template = RUIPlugin.getInstance().getRCodeGenerationTemplateStore().findTemplate("roxygen_S4ClassDef");
            if (template == null) {
                return null;
            }
            SourceUnit su = rClass.getSourceUnit();
            RCodeTemplateContext context = new RCodeTemplateContext("roxygen_ClassDef_context", su, lineDelimiter);
            context.setRElement((RElement)rClass);
            buffer = context.evaluate(template);
            if (buffer != null) break block8;
            return null;
        }
        try {
            TemplateUtils.EvaluatedTemplate data = new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
            AbstractDocument content = data.startPostEdit();
            StringBuilder tagBuffer = new StringBuilder(64);
            TemplateVariable slotVariable = TemplateUtils.findVariable((TemplateBuffer)buffer, (String)"slot_tags");
            Position[] slotPositions = new Position[slotVariable != null ? slotVariable.getOffsets().length : 0];
            int i = 0;
            while (i < slotPositions.length) {
                slotPositions[i] = new Position(slotVariable.getOffsets()[i], slotVariable.getLength());
                content.addPosition(slotPositions[i]);
                ++i;
            }
            if (slotPositions.length > 0) {
                List slots = rClass.getModelChildren(RElement.R_S4SLOT_FILTER);
                int count = slots.size();
                String[] tags = new String[count];
                int i2 = 0;
                while (i2 < count) {
                    RLangSlot slot = (RLangSlot)slots.get(i2);
                    tagBuffer.append("@slot ");
                    tagBuffer.append(slot.getElementName().getDisplayName());
                    tagBuffer.append(" ");
                    tags[i2] = tagBuffer.toString();
                    tagBuffer.setLength(0);
                    ++i2;
                }
                Position[] positionArray = slotPositions;
                int n = slotPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    Position pos = positionArray[n2];
                    CodeGeneration.insertRoxygen(content, pos, tags);
                    ++n2;
                }
            }
            data.finishPostEdit();
            return data;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
        }
    }

    public static TemplateUtils.EvaluatedTemplate getMethodRoxygenComment(RLangMethod rMethod, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        Template template;
        block14: {
            template = RUIPlugin.getInstance().getRCodeGenerationTemplateStore().findTemplate("roxygen_S4MethodDef");
            if (template == null) {
                return null;
            }
            SourceUnit su = rMethod.getSourceUnit();
            RCodeTemplateContext context = new RCodeTemplateContext("roxygen_MethodDef_context", su, lineDelimiter);
            context.setRElement((RElement)rMethod);
            buffer = context.evaluate(template);
            if (buffer != null) break block14;
            return null;
        }
        try {
            Position pos;
            Parameters parameters;
            int i;
            Parameters parameters2;
            TemplateUtils.EvaluatedTemplate data = new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
            AbstractDocument content = data.startPostEdit();
            StringBuilder sb = new StringBuilder(64);
            String sigText = null;
            TemplateVariable variable = TemplateUtils.findVariable((TemplateBuffer)buffer, (String)"sig_list");
            Position[] sigPositions = new Position[variable != null ? variable.getOffsets().length : 0];
            int i2 = 0;
            while (i2 < sigPositions.length) {
                sigPositions[i2] = new Position(variable.getOffsets()[i2], variable.getLength());
                content.addPosition(sigPositions[i2]);
                ++i2;
            }
            if (sigPositions.length > 0 && (parameters2 = rMethod.getParameters()) != null) {
                int count = parameters2.size();
                i = 0;
                while (i < count) {
                    String className = parameters2.get(i).getClassName();
                    if (className == null || className.equals("ANY")) break;
                    sb.append(className);
                    sb.append(",");
                    ++i;
                }
                if (sb.length() > 0) {
                    sigText = sb.substring(0, sb.length() - 1);
                    sb.setLength(0);
                }
            }
            String[] paramTags = null;
            TemplateVariable variable2 = TemplateUtils.findVariable((TemplateBuffer)buffer, (String)"param_tags");
            Position[] paramPositions = new Position[variable2 != null ? variable2.getOffsets().length : 0];
            i = 0;
            while (i < paramPositions.length) {
                paramPositions[i] = new Position(variable2.getOffsets()[i], variable2.getLength());
                content.addPosition(paramPositions[i]);
                ++i;
            }
            if (paramPositions.length > 0 && (parameters = rMethod.getParameters()) != null) {
                int count = parameters.size();
                paramTags = new String[count];
                int i3 = 0;
                while (i3 < count) {
                    String paramName = parameters.get(i3).getName();
                    sb.append("@param ");
                    if (paramName != null) {
                        sb.append(paramName);
                    }
                    sb.append(" ");
                    paramTags[i3] = sb.toString();
                    sb.setLength(0);
                    ++i3;
                }
            }
            Position[] positionArray = sigPositions;
            int n = sigPositions.length;
            int n2 = 0;
            while (n2 < n) {
                pos = positionArray[n2];
                CodeGeneration.insertRoxygen(content, pos, sigText);
                ++n2;
            }
            positionArray = paramPositions;
            n = paramPositions.length;
            n2 = 0;
            while (n2 < n) {
                pos = positionArray[n2];
                CodeGeneration.insertRoxygen(content, pos, paramTags);
                ++n2;
            }
            data.finishPostEdit();
            return data;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
        }
    }

    public static TemplateUtils.EvaluatedTemplate getNewRdFileContent(BasicRResourceSourceUnit su, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        block4: {
            Template template = RUIPlugin.getInstance().getRdCodeGenerationTemplateStore().findTemplate("rd_NewRDocFile");
            if (template == null) {
                return null;
            }
            RdCodeTemplateContext context = new RdCodeTemplateContext("rd_NewRDocFile_context", (SourceUnit)su, lineDelimiter);
            try {
                buffer = context.evaluate(template);
                if (buffer != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
            }
        }
        return new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
    }

    private static void insertRoxygen(AbstractDocument doc, Position pos, String[] tags) throws BadLocationException {
        int line = doc.getLineOfOffset(pos.getOffset());
        int lineOffset = doc.getLineOffset(line);
        int lineLength = doc.getLineLength(line);
        String orgLine = doc.get(lineOffset, lineLength);
        String prefix = orgLine.substring(0, pos.getOffset() - lineOffset);
        if (tags == null) {
            return;
        }
        if (tags.length == 0) {
            if (CodeGeneration.onlyWhitespace(orgLine.substring(prefix.length(), pos.getOffset() - lineOffset)) && CodeGeneration.onlyWhitespace(orgLine.substring(pos.getOffset() - lineOffset + pos.getLength()))) {
                doc.replace(lineOffset, lineLength, "");
                return;
            }
            doc.replace(pos.getOffset(), pos.getLength(), "");
            return;
        }
        StringBuilder sb = new StringBuilder(tags.length * 16);
        sb.append(tags[0]);
        int i = 1;
        while (i < tags.length) {
            sb.append(doc.getDefaultLineDelimiter());
            sb.append(prefix);
            sb.append(tags[i]);
            ++i;
        }
        doc.replace(pos.getOffset(), pos.getLength(), sb.toString());
    }

    private static void insertRoxygen(AbstractDocument doc, Position pos, String s) throws BadLocationException {
        doc.replace(pos.getOffset(), pos.getLength(), s != null ? s : "");
    }

    private static boolean onlyWhitespace(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(0);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private CodeGeneration() {
    }
}

