/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.AbstractBreadcrumb;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLabelProvider;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpViewPage;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rhelp.core.http.RHelpHttpService;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.services.IServiceLocator;

public class RHelpBreadcrumb
extends AbstractBreadcrumb {
    private final RHelpHttpService rHelpHttpService = RCore.getRHelpHttpService();
    private final RHelpManager rHelpManager = RCore.getRHelpManager();
    private final RHelpViewPage page;
    private RHelpLabelProvider labelProvider;

    public RHelpBreadcrumb(RHelpViewPage page) {
        this.page = page;
    }

    public void setInput(Object element) {
        if (element == null) {
            element = this.rHelpHttpService;
        }
        super.setInput(element);
    }

    protected BreadcrumbViewer createViewer(Composite parent) {
        RHelpBreadcrumbViewer viewer = new RHelpBreadcrumbViewer(parent);
        this.labelProvider = new RHelpLabelProvider(0);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setToolTipLabelProvider(new RHelpLabelProvider(16));
        viewer.setContentProvider((IContentProvider)new RHelpContentProvider());
        return viewer;
    }

    protected boolean hasInputFocus() {
        return this.page.isBrowserFocusControl();
    }

    protected void setFocusToInput() {
        this.page.setFocusToBrowser();
    }

    protected IServiceLocator getParentServiceLocator() {
        return this.page.getSite();
    }

    protected boolean reveal(Object element) {
        URI url = this.rHelpHttpService.toHttpUrl(element, "browse");
        if (url != null) {
            this.page.setUrl(url);
            return true;
        }
        return false;
    }

    protected void switchTo(REnv rEnv) {
        URI url = this.rHelpHttpService.toHttpUrl(this.page.getCurrentUrl(), rEnv, "browse");
        if (url != null) {
            this.setFocusToInput();
            this.page.setUrl(url);
        }
    }

    protected boolean open(Object element) {
        return false;
    }

    private class RHelpBreadcrumbViewer
    extends BreadcrumbViewer {
        public RHelpBreadcrumbViewer(Composite parent) {
            super(parent, 256);
        }

        protected void configureDropDownViewer(TreeViewer viewer, Object input) {
            viewer.setContentProvider((IContentProvider)new RHelpContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new RHelpLabelProvider());
        }

        public void fillDropDownContextMenu(IMenuManager manager, final Object selection) {
            if (selection instanceof REnv) {
                REnv rEnv = (REnv)selection;
                manager.add((IContributionItem)new SimpleContributionItem(NLS.bind((String)"Show overview of ''{0}''", (Object)rEnv.getName()), "o"){

                    protected void execute() throws ExecutionException {
                        RHelpBreadcrumb.this.reveal(selection);
                        RHelpBreadcrumb.this.setFocusToInput();
                    }
                });
                manager.add((IContributionItem)new SimpleContributionItem(NLS.bind((String)"Show current page in ''{0}''", (Object)rEnv.getName()), "p"){

                    protected void execute() throws ExecutionException {
                        RHelpBreadcrumb.this.switchTo((REnv)selection);
                    }
                });
            }
        }
    }

    private class RHelpContentProvider
    implements ITreeContentProvider {
        private RHelpContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            if (element instanceof REnv || element instanceof String) {
                return RHelpBreadcrumb.this.rHelpManager;
            }
            if (element instanceof RPkgHelp) {
                return ((RPkgHelp)element).getREnv();
            }
            if (element instanceof RHelpPage) {
                return ((RHelpPage)element).getPackage();
            }
            if (element instanceof Object[]) {
                return ((Object[])element)[0];
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RHelpManager) {
                return true;
            }
            if (element instanceof REnv) {
                return RHelpBreadcrumb.this.rHelpManager.hasHelp((REnv)element);
            }
            if (element instanceof RPkgHelp) {
                return !((RPkgHelp)element).getPages().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof RHelpManager) {
                List rEnvsWithHelp = RHelpBreadcrumb.this.rHelpManager.getREnvsWithHelp();
                @NonNull Object[] children = rEnvsWithHelp.toArray(new REnv[rEnvsWithHelp.size()]);
                Arrays.sort(children, REnvUtils.getComparator((Locale)Locale.getDefault()));
                return children;
            }
            if (element instanceof REnv) {
                REnvHelp help = RHelpBreadcrumb.this.rHelpManager.getHelp((REnv)element);
                if (help != null) {
                    try {
                        Object[] objectArray = help.getPkgs().toArray();
                        return objectArray;
                    }
                    finally {
                        help.unlock();
                    }
                }
                return new Object[0];
            }
            if (element instanceof RPkgHelp) {
                return ((RPkgHelp)element).getPages().toArray();
            }
            return new Object[0];
        }
    }
}

