/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;

public class ElementNameComparator
extends ViewerComparator
implements Comparator<LtkModelElement> {
    public ElementNameComparator(Comparator<? super ElementName> nameComparator) {
        super(nameComparator);
    }

    public int category(Object element) {
        return this.category((LtkModelElement)element);
    }

    public int category(LtkModelElement element) {
        switch (element.getElementType() & 0xF00) {
            case 768: {
                return 1;
            }
            case 1024: {
                return 2;
            }
        }
        return 100;
    }

    @Override
    public int compare(LtkModelElement e1, LtkModelElement e2) {
        int c2;
        int c1 = this.category(e1);
        if (c1 != (c2 = this.category(e2))) {
            return c1 - c2;
        }
        int result = this.getComparator().compare(e1.getElementName(), e2.getElementName());
        if (result != 0) {
            return result;
        }
        if (e1 instanceof SourceStructElement && e2 instanceof SourceStructElement) {
            return ((SourceStructElement)e1).getSourceRange().getStartOffset() - ((SourceStructElement)e2).getSourceRange().getStartOffset();
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof LtkModelElement) {
            if (e2 instanceof LtkModelElement) {
                return this.compare((LtkModelElement)e1, (LtkModelElement)e2);
            }
            return Integer.MIN_VALUE;
        }
        if (e2 instanceof LtkModelElement) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

