/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ast.core.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.util.SourceMessageUtil;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.impl.BasicProblem;

@NonNullByDefault
public class AbstractAstProblemReporter {
    protected static final int MASK = 0xFFFFFF;
    private final String modelTypeId;
    private final boolean reportSubsequent = false;
    private SourceContent sourceContent = (SourceContent)((Object)ObjectUtils.nonNullLateInit());
    private IssueRequestor requestor = (IssueRequestor)ObjectUtils.nonNullLateInit();
    private final SourceMessageUtil messageUtil = new SourceMessageUtil();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);

    public AbstractAstProblemReporter(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public String getModelTypeId() {
        return this.modelTypeId;
    }

    protected void init(SourceContent content, IssueRequestor requestor) {
        this.sourceContent = (SourceContent)((Object)ObjectUtils.nonNullAssert((Object)((Object)content)));
        this.messageUtil.setSourceContent(content);
        this.requestor = (IssueRequestor)ObjectUtils.nonNullAssert((Object)requestor);
    }

    protected void flush() {
        if (!this.problemBuffer.isEmpty()) {
            this.requestor.acceptProblems(this.modelTypeId, this.problemBuffer);
        }
    }

    protected void clear() {
        this.problemBuffer.clear();
        this.sourceContent = null;
        this.requestor = null;
    }

    protected final boolean requiredCheck(int code) {
        return code != 0 && (code & 0x800000) == 0;
    }

    protected final SourceMessageUtil getMessageUtil() {
        return this.messageUtil;
    }

    protected final MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        } else if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        this.problemBuffer.add(new BasicProblem(this.modelTypeId, severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.requestor.acceptProblems(this.modelTypeId, this.problemBuffer);
            this.problemBuffer.clear();
        }
    }

    protected void handleCommonCodes(AstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0xF00) {
            case 3840: {
                this.addProblem(2, code, "Error when parsing source code. Please submit a bug report with a code snippet / log entry.", node.getStartOffset(), node.getStartOffset());
                return;
            }
        }
        this.handleUnknownCodes(node);
    }

    protected void handleUnknownCodes(AstNode node) {
        int code = node.getStatusCode() & 0xFFFFFF;
        StringBuilder sb = new StringBuilder();
        sb.append("Unhandled/Unknown code of AST node (").append(this.modelTypeId).append("):");
        sb.append('\n');
        sb.append("  code= ").append(String.format("0x%1$08X", code));
        sb.append('\n');
        sb.append("  node= ").append(node);
        sb.append(" (").append(node.getStartOffset()).append(", ").append(node.getLength()).append(')');
        sb.append('\n');
        if (this.sourceContent != null) {
            TextLineInformation lines = this.sourceContent.getStringLines();
            int line = lines.getLineOfOffset(node.getStartOffset() - this.sourceContent.getStartOffset());
            sb.append("  Line ").append(line + 1);
            sb.append('\n');
            int firstLine = Math.max(0, line - 2);
            int lastLine = Math.min(lines.getNumberOfLines() - 1, lines.getLineOfOffset(node.getEndOffset() - this.sourceContent.getStartOffset()) + 2);
            sb.append("  source (line ").append(firstLine + 1).append('-').append(lastLine + 1).append(")= \n");
            sb.append(this.sourceContent.getString(), lines.getStartOffset(firstLine), lines.getEndOffset(lastLine));
        }
        LtkCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ltk.core", sb.toString()));
    }

    protected int expandSpaceStart(int offset) {
        switch (this.sourceContent.contains(offset - 1) ? (int)this.sourceContent.getChar(offset - 1) : -1) {
            case 9: 
            case 32: {
                return offset - 1;
            }
        }
        return offset;
    }

    protected int expandSpaceEnd(int offset) {
        switch (this.sourceContent.contains(offset) ? (int)this.sourceContent.getChar(offset) : -1) {
            case 9: 
            case 32: {
                return offset + 1;
            }
        }
        return offset;
    }
}

