/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;

@NonNullByDefault
public abstract class BundleEntry
implements Comparable<BundleEntry> {
    protected final String bundleId;
    private final Path path;

    public BundleEntry(String bundleId, Path path) {
        this.bundleId = bundleId;
        this.path = path;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    @Override
    public int compareTo(BundleEntry o) {
        return this.bundleId.compareTo(o.bundleId);
    }

    public final Path getPath() {
        return this.path;
    }

    public String getUrlString() {
        return this.path.toUri().toString();
    }

    public Path getJClassPath() {
        return this.path;
    }

    public String getJClassPathString() {
        return this.getJClassPath().toString();
    }

    public String getJClassPathUrlString() {
        return this.getJClassPath().toUri().toString();
    }

    @Deprecated
    public String getCodebaseString() {
        return this.getJClassPath().toUri().toString();
    }

    public @Nullable Path getResourcePath(String resource) {
        return this.path.resolve(resource);
    }

    public @Nullable String getResourceUrlString(String resource) {
        Path path = this.getResourcePath(resource);
        if (path != null) {
            return path.toUri().toString();
        }
        return null;
    }

    public int hashCode() {
        return this.bundleId.hashCode() + this.getPath().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BundleEntry) {
            BundleEntry other = (BundleEntry)obj;
            return this.bundleId.equals(other.bundleId) && this.getPath().equals(other.getPath());
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format("'%1$s' -> '%2$s'", this.bundleId, this.getUrlString());
    }

    public static class Dir
    extends BundleEntry {
        private final Path jClassPath;

        public Dir(String bundleId, Path path, Path jClassPath) {
            super(bundleId, path);
            this.jClassPath = jClassPath;
        }

        @Override
        public Path getJClassPath() {
            return this.jClassPath;
        }
    }

    public static class Jar
    extends BundleEntry {
        private @Nullable Path contentRoot;

        public Jar(String bundleId, Path path) {
            super(bundleId, path);
        }

        @Override
        public String getJClassPathUrlString() {
            String urlString = super.getJClassPathUrlString();
            if (UriUtils.isJarUrl(urlString)) {
                try {
                    urlString = UriUtils.toJarUrlString(urlString);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return urlString;
        }

        private synchronized Path getContentRootPath() throws IOException, URISyntaxException, ProviderNotFoundException {
            Path root = this.contentRoot;
            if (root == null) {
                FileSystem jarFS = FileSystems.newFileSystem(this.getPath(), null);
                this.contentRoot = root = jarFS.getPath("/", new String[0]);
            }
            return root;
        }

        @Override
        public @Nullable Path getResourcePath(String resource) {
            try {
                return this.getContentRootPath().resolve(resource);
            }
            catch (IOException | ProviderNotFoundException e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("An error occured while resolving resource path '%1$s' in '%2$s'.", resource, this), e));
                return null;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @Nullable String getResourceUrlString(String resource) {
            try {
                String urlString = UriUtils.toJarUrlString(this.getUrlString());
                if (urlString.endsWith("/")) {
                    return String.valueOf(urlString) + resource;
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

