/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectRelativeCellCommand;
import org.eclipse.statet.ecommons.waltable.viewport.core.SelectRelativePageCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SelectRelativePageCommandHandler
implements LayerCommandHandler<SelectRelativePageCommand> {
    private final Layer viewportLayer;

    public SelectRelativePageCommandHandler(Layer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<SelectRelativePageCommand> getCommandClass() {
        return SelectRelativePageCommand.class;
    }

    @Override
    public boolean executeCommand(SelectRelativePageCommand command) {
        long stepCount;
        switch (command.getDirection()) {
            case UP: 
            case DOWN: {
                stepCount = this.viewportLayer.getRowCount();
                break;
            }
            case LEFT: 
            case RIGHT: {
                stepCount = this.viewportLayer.getColumnCount();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.viewportLayer.doCommand(new SelectRelativeCellCommand(command.getDirection(), stepCount, command.getSelectionFlags()));
        return true;
    }
}

