/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.workspace;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.workbench.workspace.AbstractResourceSelectionDialog;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceContentProvider;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourceContainerSelectionDialog
extends AbstractResourceSelectionDialog<IContainer> {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 75;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 20;
    private TreeViewer selectionViewer;

    public ResourceContainerSelectionDialog(Shell parent, String message) {
        super(parent);
        this.setTitle(Messages.ResourceSelectionDialog_title);
        this.setMessage(message);
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.ResourceSelectionDialog_SelectContainer_message;
    }

    @Override
    protected int getResourceTypes() {
        return 6;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        TreeViewer viewer = new TreeViewer(composite, 2052);
        viewer.setContentProvider((IContentProvider)new ResourceContentProvider(6));
        viewer.setComparator((ViewerComparator)new ResourceComparator(1));
        viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        viewer.setInput((Object)this.getRootElement());
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(75);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        viewer.getControl().setLayoutData((Object)gd);
        this.selectionViewer = viewer;
        this.selectionViewer.addSelectionChangedListener(this.createSelectionChangeListener());
        this.selectionViewer.addDoubleClickListener(this.createSelectionDoubleClickListener());
        this.createTextField(composite);
        return composite;
    }

    @Override
    protected void initSelection(List<IResource> checkedResources) {
        this.selectionViewer.setSelection((ISelection)new StructuredSelection(checkedResources), true);
    }
}

