/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;

public class CornerLayer
extends DimensionallyDependentLayer {
    public CornerLayer(ILayer baseLayer, ILayer horizontalLayerDependency, ILayer verticalLayerDependency) {
        this(baseLayer, horizontalLayerDependency, verticalLayerDependency, true, new CellLayerPainter());
    }

    public CornerLayer(ILayer baseLayer, ILayer horizontalLayerDependency, ILayer verticalLayerDependency, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, horizontalLayerDependency, verticalLayerDependency);
        this.layerPainter = layerPainter;
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        ILayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new LayerCell(this, new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, 0L, hDim.getPositionCount()), new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition, 0L, this.getVerticalLayerDependency().getRowCount()));
    }
}

