/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.ContinuePrompt;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RDbg;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.r.nico.IRModelSrcref;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.server.dbg.CallStack;
import org.eclipse.statet.rj.server.dbg.CtrlReport;
import org.eclipse.statet.rj.server.dbg.DbgEnablement;
import org.eclipse.statet.rj.server.dbg.DbgFilterState;
import org.eclipse.statet.rj.server.dbg.DbgRequest;
import org.eclipse.statet.rj.server.dbg.ElementTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.Frame;
import org.eclipse.statet.rj.server.dbg.FrameContext;
import org.eclipse.statet.rj.server.dbg.FrameRef;
import org.eclipse.statet.rj.server.dbg.SetDebugReport;
import org.eclipse.statet.rj.server.dbg.SetDebugRequest;
import org.eclipse.statet.rj.server.dbg.SrcfileData;
import org.eclipse.statet.rj.server.dbg.TracepointEvent;
import org.eclipse.statet.rj.server.dbg.TracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.TracepointStatesUpdate;
import org.eclipse.statet.rj.services.RVersion;

public abstract class AbstractRDbgController
extends AbstractRController
implements IRDataAdapter,
ICombinedRDataAdapter {
    private static final int TOPLEVELBROWSER_ENABLE_COMMANDS = 1;
    private static final int TOPLEVELBROWSER_CHECK_SUSPENDED = 3;
    private static final int TOPLEVELBROWSER_CHECK_SUBMIT = 4;
    protected static final RReference TOPLEVEL_ENV_FRAME = new RReferenceImpl(0L, 8, null);
    private IRControllerTracepointAdapter breakpointAdapter;
    private CallStack callStack;
    private int callStackStamp;
    private RReference globalEnv;
    private boolean suspendScheduled;
    private final ToolRunnable suspendRunnable = new ToolController.ControllerSystemRunnable(this, "common/debug/suspend", "Suspend"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: 
                case 336: 
                case 340: 
                case 344: {
                    ToolRunnable toolRunnable = AbstractRDbgController.this.suspendRunnable;
                    synchronized (toolRunnable) {
                        AbstractRDbgController.this.suspendScheduled = false;
                        break;
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            if (AbstractRDbgController.this.getStatusL() == ToolStatus.STARTED_SUSPENDED || AbstractRDbgController.this.getHotTasksState() <= 1 && (((AbstractRDbgController)AbstractRDbgController.this).fCurrentPrompt.meta & 4) != 0) {
                return;
            }
            if (AbstractRDbgController.this.topLevelBrowserAction == 0) {
                AbstractRDbgController.this.topLevelBrowserAction = 4;
            }
            AbstractRDbgController.this.doRequestSuspend(m);
        }
    };
    private boolean topLevelBrowserEnabled;
    private int topLevelBrowserAction;
    private final SystemRunnable fTopLevelBrowserRunnable = new ToolController.ControllerSystemRunnable(this, "r/debug", "Debugging"){

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            if (AbstractRDbgController.this.getCurrentLevelL() == 0) {
                if ((((AbstractRDbgController)AbstractRDbgController.this).fCurrentPrompt.meta & 4) != 0) {
                    AbstractRDbgController.this.setSuspended(AbstractRDbgController.this.getBrowserLevel(((AbstractRDbgController)AbstractRDbgController.this).fCurrentPrompt.text), 0, null);
                } else if ((((AbstractRDbgController)AbstractRDbgController.this).fCurrentPrompt.meta & 2) != 0) {
                    switch (AbstractRDbgController.this.topLevelBrowserAction) {
                        case 1: {
                            AbstractRDbgController.this.initTopLevelBrowser(m);
                            break;
                        }
                        case 3: {
                            if (AbstractRDbgController.this.getQueue().getCurrentSize() > 0) {
                                AbstractRDbgController.this.topLevelBrowserAction = 4;
                                break;
                            }
                            AbstractRDbgController.this.setDebugBrowser(TOPLEVEL_ENV_FRAME, false, false, m);
                        }
                        default: {
                            AbstractRDbgController.this.removePostControllerRunnable((ToolRunnable)AbstractRDbgController.this.fTopLevelBrowserRunnable);
                        }
                    }
                }
            }
        }
    };
    private String lastSrcfile;
    private String lastSrcfilePath;
    private TracepointEvent breakpointHit;

    public AbstractRDbgController(RProcess process, Map<String, Object> connectionInfo) {
        super(process, connectionInfo);
    }

    public void initDebug(IRControllerTracepointAdapter breakpointAdapter) {
        if (breakpointAdapter == null) {
            throw new NullPointerException("breakpointAdapter");
        }
        this.setDebugEnabled(true);
        this.breakpointAdapter = breakpointAdapter;
        class LoadCallstackRunnable
        extends ToolController.ControllerSystemRunnable
        implements SystemRunnable {
            public LoadCallstackRunnable() {
                super((ToolController)AbstractRDbgController.this, "r/callstack", "Load Callstack");
            }

            public void run(ToolService service, ProgressMonitor m) throws StatusException {
                AbstractRDbgController.this.getCallStack(m);
            }
        }
        this.addSuspendUpdateRunnable(new LoadCallstackRunnable());
        this.addToolStatusListener(new ToolController.IToolStatusListener(){

            public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
                switch (newStatus) {
                    case STARTED_IDLING: 
                    case STARTED_PROCESSING: 
                    case TERMINATED: {
                        AbstractRDbgController.this.callStack = null;
                    }
                }
            }
        });
    }

    protected final void setCurrentPromptL(String text, boolean addToHistory) {
        TracepointEvent hit = this.breakpointHit;
        this.breakpointHit = null;
        if (this.defaultPromptText.equals(text)) {
            if (this.isDebugEnabled() && this.getRequestedLevelL() != 0) {
                this.setSuspended(0, 0, null);
            }
            if (addToHistory) {
                this.setCurrentPromptL(this.fDefaultPrompt);
                return;
            }
            this.setCurrentPromptL(new Prompt(this.defaultPromptText, 3));
            return;
        }
        if (this.continuePromptText.equals(text)) {
            this.setCurrentPromptL(new ContinuePrompt(this.fCurrentPrompt, String.valueOf(this.fCurrentInput) + this.fLineSeparator, this.continuePromptText, addToHistory ? 0 : 1));
            return;
        }
        if (text != null) {
            if (this.isDebugEnabled() && text.startsWith("Browse[") && text.endsWith("]> ")) {
                this.callStack = null;
                this.setSuspended(this.getBrowserLevel(text), hit != null ? 16 : 0, hit != null ? this.breakpointAdapter.toEclipseData(hit) : null);
                this.setCurrentPromptL(new Prompt(text, addToHistory ? 4 : 5));
                return;
            }
            this.setCurrentPromptL(new Prompt(text, addToHistory ? 0 : 1));
            return;
        }
        this.setCurrentPromptL(new Prompt("", addToHistory ? 0 : 1));
    }

    private int getBrowserLevel(String prompt) {
        return Integer.parseInt(prompt.substring(7, prompt.indexOf(93)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean runConsoleCommandInSuspend(String input) {
        ToolStreamProxy streams = this.getStreams();
        if ((this.getPrompt().meta & 4) == 0) return true;
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            streams.getOutputStreamMonitor().append(this.fLineSeparator, SubmitType.TOOLS, 0);
            return false;
        }
        if (trimmed.length() != 1) return true;
        try {
            switch (trimmed.charAt(0)) {
                case 'Q': {
                    this.debugCancel();
                    return false;
                }
                case 'c': {
                    if (!this.exec((DbgRequest)new DbgRequest.Resume())) return true;
                    return false;
                }
                case 'n': {
                    if (!this.exec((DbgRequest)new DbgRequest.StepOver())) return true;
                    return false;
                }
                case 's': {
                    if (!this.exec((DbgRequest)new DbgRequest.StepInto())) return true;
                    return false;
                }
            }
            return true;
        }
        catch (StatusException e) {
            RConsoleCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(1, "org.eclipse.statet.r.console.core", 0, "An error occurred when executing debug request in the R engine.", (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugSuspend() {
        ToolRunnable toolRunnable = this.suspendRunnable;
        synchronized (toolRunnable) {
            if (this.suspendScheduled) {
                return;
            }
            this.suspendScheduled = true;
        }
        this.getQueue().addHot(this.suspendRunnable);
    }

    /*
     * Inner class renamed, behaviour may change
     */
    public boolean exec(DbgRequest request) throws StatusException {
        switch (request.getOp()) {
            class DbgRequestResumeRunnable3<R extends DbgRequest>
            extends ToolController.SuspendResumeRunnable {
                private final /* synthetic */ DbgRequest val$request;

                public DbgRequestResumeRunnable3(String id, String label, DbgRequest dbgRequest) {
                    this.val$request = dbgRequest;
                    super((ToolController)AbstractRDbgController.this, id, label, RDbg.getResumeEventDetail(dbgRequest.getOp()));
                }

                protected DbgRequest check(R request, ProgressMonitor m) {
                    return request;
                }

                public void run(ToolService adapter, ProgressMonitor m) throws StatusException {
                    if ((AbstractRDbgController.this.getPrompt().meta & 4) == 0) {
                        return;
                    }
                    DbgRequest checkedRequest = this.check(this.val$request, m);
                    if (checkedRequest == null) {
                        return;
                    }
                    CtrlReport report = AbstractRDbgController.this.doExec(checkedRequest, m);
                    if (!report.isEngineSuspended()) {
                        super.run(adapter, m);
                        this.submitToConsole(this.getResumeRCommand(report.getOp()), null, m);
                        this.setDetail(RDbg.getResumeEventDetail(report.getOp()));
                    }
                }

                protected void doExec(ProgressMonitor m) throws StatusException {
                    AbstractRDbgController.this.briefChanged(1);
                }

                protected String getResumeRCommand(byte op) {
                    switch (op) {
                        case 9: {
                            return "c";
                        }
                        case 10: {
                            return "s";
                        }
                        case 12: {
                            return "n";
                        }
                    }
                    return "c";
                }
            }
            case 9: {
                this.scheduleSuspendExitRunnable(new DbgRequestResumeRunnable3<DbgRequest.Resume>(this, "common/debug/resume", "Resume", request){
                    {
                        super($anonymous0, $anonymous1, dbgRequest);
                    }

                    @Override
                    protected void doExec(ProgressMonitor m) throws StatusException {
                        super.doExec(m);
                        topLevelBrowserEnabled = false;
                    }
                });
                return true;
            }
            case 12: {
                this.scheduleSuspendExitRunnable(new DbgRequestResumeRunnable3("common/debug/step.over", "Step Over", request));
                return true;
            }
            case 10: {
                if (this.getPlatform().getRVersion().compareTo(new RVersion(3, 1, 0)) < 0) {
                    return false;
                }
                this.scheduleSuspendExitRunnable(new DbgRequestResumeRunnable3("common/debug/step.in", "Step Into", request));
                return true;
            }
            case 14: {
                this.scheduleSuspendExitRunnable(new DbgRequestResumeRunnable3<DbgRequest.StepReturn>(this, "common/debug/step.return", "Step Return", request){
                    private Frame targetFrame;
                    {
                        super($anonymous0, $anonymous1, dbgRequest);
                    }

                    @Override
                    protected DbgRequest check(DbgRequest.StepReturn request, ProgressMonitor m) {
                        CallStack callStack = this.getCallStack(m);
                        if (request.getTarget() instanceof FrameRef.ByPosition) {
                            int targetPosition = ((FrameRef.ByPosition)request.getTarget()).getPosition();
                            int n = callStack.getFrames().size();
                            if (targetPosition >= 0 && targetPosition < n - 1) {
                                this.targetFrame = (Frame)callStack.getFrames().get(targetPosition);
                            }
                        } else if (request.getTarget() instanceof FrameRef.ByHandle) {
                            long targetHandle = ((FrameRef.ByHandle)request.getTarget()).getHandle();
                            this.targetFrame = callStack.findFrame(targetHandle);
                        }
                        return this.targetFrame != null ? new DbgRequest.StepReturn((FrameRef)new FrameRef.ByHandle(this.targetFrame.getHandle())) : null;
                    }

                    @Override
                    protected void doExec(ProgressMonitor m) throws StatusException {
                        super.doExec(m);
                    }
                });
                return true;
            }
        }
        throw new UnsupportedOperationException(request.toString());
    }

    public void debugStepInto(final int position, final String fRefCode) throws StatusException {
        this.scheduleSuspendExitRunnable(new ToolController.SuspendResumeRunnable(this, "common/debug/step.in", "Step Into", 2){

            protected boolean canExec(ProgressMonitor m) throws StatusException {
                CallStack stack;
                if ((AbstractRDbgController.this.getPrompt().meta & 4) != 0 && (stack = AbstractRDbgController.this.getCallStack(m)) != null) {
                    int n = stack.getFrames().size();
                    if (n == 0 || position > n) {
                        return false;
                    }
                    int pos = position >= 0 ? position : stack.getFrames().size() - 1;
                    try {
                        SetDebugReport report = AbstractRDbgController.this.doExec(new SetDebugRequest(pos, fRefCode, true, true), m);
                        return report != null;
                    }
                    catch (Exception e) {
                        RConsoleCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(1, "org.eclipse.statet.r.console.core", 0, "A problem occurred when stepping into the specified function call: Could not prepare debug for '" + fRefCode + "'.", (Throwable)e));
                        return false;
                    }
                }
                return false;
            }

            protected void doExec(ProgressMonitor m) throws StatusException {
                AbstractRDbgController.this.briefChanged(1);
                this.submitToConsole("c", "c", m);
            }
        });
    }

    public void debugCancel() throws StatusException {
        this.scheduleSuspendExitRunnable(new ToolController.SuspendResumeRunnable(this, "common/debug/resume", "Cancel", 32){

            protected boolean canExec(ProgressMonitor m) throws StatusException {
                return (AbstractRDbgController.this.getPrompt().meta & 4) != 0;
            }

            protected void doExec(ProgressMonitor m) throws StatusException {
                AbstractRDbgController.this.briefChanged(1);
                AbstractRDbgController.this.topLevelBrowserEnabled = false;
                AbstractRDbgController.this.topLevelBrowserAction = 4;
                this.submitToConsole("Q", "Q", m);
            }
        });
    }

    protected ToolController.QuitRunnable createQuitRunnable() {
        return new ToolController.QuitRunnable(this){

            protected void doExec(ProgressMonitor m) throws StatusException {
                if ((AbstractRDbgController.this.getPrompt().meta & 4) != 0) {
                    AbstractRDbgController.this.briefChanged(1);
                    AbstractRDbgController.this.topLevelBrowserEnabled = false;
                    AbstractRDbgController.this.topLevelBrowserAction = 4;
                    this.submitToConsole("Q", "Q", m);
                }
            }
        };
    }

    @Override
    protected void doQuitL(ProgressMonitor m) throws StatusException {
        if ((this.getPrompt().meta & 4) == 0) {
            super.doQuitL(m);
        }
    }

    protected void runSuspendedLoopL(int o) {
        if (this.topLevelBrowserAction == 4) {
            this.topLevelBrowserAction = 0;
        }
        this.removePostControllerRunnable((ToolRunnable)this.fTopLevelBrowserRunnable);
        super.runSuspendedLoopL(o);
        if (this.getCurrentLevelL() == 0) {
            if (this.topLevelBrowserAction == 0) {
                this.topLevelBrowserAction = 4;
            }
            this.addPostControllerRunnable(this.fTopLevelBrowserRunnable);
        }
    }

    public CallStack getCallStack(ProgressMonitor m) {
        if (this.callStack == null || this.callStackStamp != this.getChangeStamp()) {
            this.callStackStamp = this.getChangeStamp();
            try {
                this.callStack = this.doEvalCallStack(m);
            }
            catch (Exception e) {
                this.callStack = null;
                RConsoleCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", 0, "An error occurred when loading the R call stack.", (Throwable)e));
            }
        }
        return this.callStack;
    }

    public FrameContext evalFrameContext(int position, ProgressMonitor m) throws StatusException {
        try {
            return this.doEvalFrameContext(position, m);
        }
        catch (Exception e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", NLS.bind((String)"An error occurred when loading detail of R stack frame {0}.", (Object)position), (Throwable)e));
        }
    }

    public abstract void exec(DbgEnablement var1) throws StatusException;

    public abstract void exec(DbgFilterState var1) throws StatusException;

    public abstract void exec(TracepointStatesUpdate var1) throws StatusException;

    public abstract void exec(TracepointStatesUpdate var1, ProgressMonitor var2) throws StatusException;

    public abstract void exec(TracepointInstallationRequest var1, ProgressMonitor var2) throws StatusException;

    @Override
    public Set<Long> getLazyEnvironments(ProgressMonitor m) {
        CallStack stack;
        Set<Long> list = super.getLazyEnvironments(m);
        if (this.isSuspendedL() && (stack = this.getCallStack(m)) != null) {
            List frames = stack.getFrames();
            if (list == null) {
                list = new HashSet<Long>(frames.size());
            }
            int i = 0;
            while (i < frames.size()) {
                long handle = ((Frame)frames.get(i)).getHandle();
                if (handle != 0L) {
                    list.add(handle);
                }
                ++i;
            }
        }
        return list;
    }

    protected CallStack doEvalCallStack(ProgressMonitor m) throws StatusException {
        return null;
    }

    protected FrameContext doEvalFrameContext(int position, ProgressMonitor m) throws Exception {
        return null;
    }

    public void initTopLevelBrowser(ProgressMonitor m) throws StatusException {
        if ((this.fCurrentPrompt.meta & 2) == 0) {
            return;
        }
        if (this.topLevelBrowserAction != 3) {
            this.topLevelBrowserAction = 4;
        }
        this.setDebugBrowser(TOPLEVEL_ENV_FRAME, true, false, m);
    }

    private void checkInit(ProgressMonitor m) throws StatusException {
        if (this.globalEnv == null) {
            try {
                this.globalEnv = RDataUtils.checkRReference((RObject)this.evalData(".GlobalEnv", null, 0, 0, m));
            }
            catch (UnexpectedRDataException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Init debug data failed.", (Throwable)e));
            }
        }
    }

    protected boolean setDebugBrowser(RReference environment, boolean enable, boolean temp, ProgressMonitor m) throws StatusException {
        this.checkInit(m);
        if (environment == TOPLEVEL_ENV_FRAME || environment.getHandle() == this.globalEnv.getHandle()) {
            this.topLevelBrowserEnabled = enable;
            if (enable) {
                if (this.topLevelBrowserAction == 0) {
                    this.topLevelBrowserAction = 4;
                }
            } else if (this.topLevelBrowserAction != 1) {
                this.topLevelBrowserAction = 0;
            }
        }
        try {
            SetDebugReport report = this.doExec(new SetDebugRequest(environment.getHandle(), enable, temp), m);
            return report != null && report.isChanged();
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "An error occurred when changing the R debug browser state.", (Throwable)e));
        }
    }

    protected SetDebugReport doExec(SetDebugRequest request, ProgressMonitor m) throws StatusException {
        return null;
    }

    protected boolean canSuspend(ProgressMonitor m) {
        return true;
    }

    protected void doRequestSuspend(ProgressMonitor m) throws StatusException {
    }

    protected void handleTracepointEvents(List<? extends TracepointEvent> events) {
        for (TracepointEvent tracepointEvent : events) {
            try {
                if (tracepointEvent.getKind() == 1) {
                    this.breakpointHit = tracepointEvent;
                    continue;
                }
                this.breakpointAdapter.handle(tracepointEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected CtrlReport doExec(DbgRequest request, ProgressMonitor m) throws StatusException {
        return null;
    }

    public boolean acceptNewConsoleCommand() {
        return (this.fCurrentPrompt.meta & 6) != 0;
    }

    public void submitToConsole(String input, ProgressMonitor m) throws StatusException {
        if (input.indexOf(10) >= 0) {
            String[] lines = RUtil.LINE_SEPARATOR_PATTERN.split(input);
            int i = 0;
            while (i < lines.length) {
                if (this.topLevelBrowserAction != 0 && this.getCurrentLevelL() == 0 && (this.fCurrentPrompt.meta & 2) != 0) {
                    this.topLevelBrowserAction = 0;
                    this.setDebugBrowser(TOPLEVEL_ENV_FRAME, false, false, m);
                }
                super.submitToConsole(lines[i], m);
                ++i;
            }
            return;
        }
        if (this.topLevelBrowserAction != 0 && this.getCurrentLevelL() == 0 && (this.fCurrentPrompt.meta & 2) != 0) {
            this.topLevelBrowserAction = 0;
            this.setDebugBrowser(TOPLEVEL_ENV_FRAME, false, false, m);
        }
        super.submitToConsole(input, m);
    }

    @Override
    public void submitCommandToConsole(String[] lines, IRSrcref srcref, ProgressMonitor m) throws StatusException {
        ElementTracepointInstallationRequest breakpointsRequest;
        if (this.isDebugEnabled() && this.getCurrentLevelL() == 0 && (this.fCurrentPrompt.meta & 2) != 0) {
            if (this.topLevelBrowserAction == 1) {
                this.initTopLevelBrowser(m);
            } else if (!this.topLevelBrowserEnabled && srcref instanceof IRModelSrcref && this.breakpointAdapter.matchScriptBreakpoint((IRModelSrcref)srcref, m)) {
                this.initTopLevelBrowser(m);
            }
        }
        SrcfileData srcfile = this.getSrcfile(srcref, m);
        this.doSubmitCommandL(lines, srcfile, srcref, m);
        if (this.isDebugEnabled() && srcfile != null && srcref instanceof IRModelSrcref && (breakpointsRequest = this.breakpointAdapter.getElementTracepoints(srcfile, (IRModelSrcref)srcref, m)) != null) {
            this.breakpointAdapter.installElementTracepoints(breakpointsRequest, m);
        }
    }

    protected void doSubmitCommandL(String[] lines, SrcfileData srcfile, IRSrcref srcref, ProgressMonitor m) throws StatusException {
        super.submitCommandToConsole(lines, srcref, m);
    }

    @Override
    public void submitFileCommandToConsole(String[] lines, SourceUnit su, ProgressMonitor m) throws StatusException {
        if (su == null) {
            super.submitFileCommandToConsole(lines, null, m);
            return;
        }
        SrcfileData srcfile = this.getSrcfile(su, m);
        ElementTracepointInstallationRequest breakpointsRequest = this.isDebugEnabled() && su instanceof RWorkspaceSourceUnit ? this.breakpointAdapter.prepareFileElementTracepoints(srcfile, (RSourceUnit)su, m) : null;
        try {
            this.doSubmitFileCommandToConsole(lines, srcfile, su, m);
        }
        finally {
            if (breakpointsRequest != null) {
                if (srcfile.getTimestamp() != this.getTimestamp((WorkspaceSourceUnit)((RWorkspaceSourceUnit)su), m)) {
                    srcfile = null;
                }
                this.breakpointAdapter.finishFileElementTracepoints(srcfile, (RSourceUnit)su, breakpointsRequest, m);
            }
        }
    }

    public void doSubmitFileCommandToConsole(String[] lines, SrcfileData srcfile, SourceUnit su, ProgressMonitor m) throws StatusException {
        super.submitFileCommandToConsole(lines, su, m);
    }

    protected SrcfileData getSrcfile(IRSrcref srcref, ProgressMonitor m) throws StatusException {
        if (srcref instanceof IRModelSrcref) {
            return this.getSrcfile((SourceUnit)((IRModelSrcref)srcref).getFile(), m);
        }
        return null;
    }

    private long getTimestamp(WorkspaceSourceUnit su, ProgressMonitor m) {
        return su.getWorkingContext() == Ltk.PERSISTENCE_CONTEXT ? su.getResource().getLocalTimeStamp() : RDbg.getTimestamp((SourceUnit)su, m);
    }

    protected SrcfileData getSrcfile(SourceUnit su, ProgressMonitor m) throws StatusException {
        String fileName = null;
        if (su != null && su.getResource() != null) {
            URI uri = null;
            FileUtil fileUtil = FileUtil.getFileUtil((Object)su.getResource());
            if (fileUtil != null) {
                uri = fileUtil.getURI();
            }
            if (uri != null) {
                fileName = uri.toString();
                try {
                    IFileStore store = EFS.getStore((URI)uri);
                    if (store != null) {
                        fileName = this.getWorkspaceData().toToolPath(store);
                    }
                }
                catch (CoreException | StatusException store) {
                    // empty catch block
                }
            }
            if (fileName == null) {
                return null;
            }
            if (su instanceof WorkspaceSourceUnit) {
                WorkspaceSourceUnit wsu = (WorkspaceSourceUnit)su;
                IPath path = wsu.getResource().getFullPath();
                this.prepareSrcfile(fileName, path, m);
                return new SrcfileData(this.lastSrcfile == fileName ? this.lastSrcfilePath : path.toPortableString(), fileName, this.getTimestamp(wsu, m));
            }
            return new SrcfileData(null, fileName, RDbg.getTimestamp(su, m));
        }
        return null;
    }

    private void prepareSrcfile(String srcfile, IPath path, ProgressMonitor m) {
        try {
            if (srcfile == null || path == null) {
                return;
            }
            String statetPath = path.toPortableString();
            if (!srcfile.equals(this.lastSrcfile) || !statetPath.equals(this.lastSrcfilePath)) {
                this.doPrepareSrcfile(srcfile, statetPath, m);
            }
            this.lastSrcfile = srcfile;
            this.lastSrcfilePath = statetPath;
        }
        catch (Exception e) {
            this.lastSrcfile = null;
            this.lastSrcfilePath = null;
            RConsoleCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", 0, "An error occurred when preparing srcfile information in R.", (Throwable)e));
        }
    }

    protected void doPrepareSrcfile(String srcfile, String statetPath, ProgressMonitor m) throws Exception {
    }

    @NonNullByDefault
    public static interface IRControllerTracepointAdapter {
        public void handle(TracepointEvent var1);

        public boolean matchScriptBreakpoint(IRModelSrcref var1, ProgressMonitor var2);

        public @Nullable ElementTracepointInstallationRequest getElementTracepoints(SrcfileData var1, IRModelSrcref var2, ProgressMonitor var3);

        public @Nullable ElementTracepointInstallationRequest prepareFileElementTracepoints(SrcfileData var1, RSourceUnit var2, ProgressMonitor var3);

        public void finishFileElementTracepoints(SrcfileData var1, RSourceUnit var2, ElementTracepointInstallationRequest var3, ProgressMonitor var4);

        public void installElementTracepoints(ElementTracepointInstallationRequest var1, ProgressMonitor var2);

        public @Nullable Object toEclipseData(TracepointEvent var1);
    }
}

