/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.r.nico.RSrcref;
import org.eclipse.statet.rj.server.dbg.SrcfileData;

@NonNullByDefault
public class RDbg {
    public static String getElementId(RLangSourceElement element) {
        SourceStructElement parent = element.getSourceParent();
        if (!(parent instanceof RLangSourceElement) || (parent.getElementType() & 0xF00) == 512) {
            return element.getId();
        }
        StringBuilder sb = new StringBuilder(element.getId());
        element = (RLangSourceElement)parent;
        while (true) {
            sb.insert(0, '/');
            sb.insert(0, element.getId());
            parent = element.getSourceParent();
            if (!(parent instanceof RLangSourceElement) || (parent.getElementType() & 0xF00) == 512) {
                return sb.toString();
            }
            element = (RLangSourceElement)parent;
        }
    }

    public static long getTimestamp(SourceUnit su, IProgressMonitor monitor) {
        FileUtil fileUtil;
        if (su.isSynchronized() && su.getResource() != null && (fileUtil = FileUtil.getFileUtil((Object)su.getResource())) != null) {
            try {
                return fileUtil.getTimeStamp(monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static long getTimestamp(SourceUnit su, ProgressMonitor m) {
        FileUtil fileUtil;
        if (su.isSynchronized() && su.getResource() != null && (fileUtil = FileUtil.getFileUtil((Object)su.getResource())) != null) {
            try {
                return fileUtil.getTimeStamp(EStatusUtils.convert((ProgressMonitor)m));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static SrcfileData createRJSrcfileData(IResource resource) {
        IPath location = resource.getLocation();
        return new SrcfileData(resource.getFullPath().toPortableString(), location != null ? location.toString() : null, resource.getLocalTimeStamp());
    }

    public static int[] createRJSrcref(IRSrcref srcref) {
        int[] array = new int[6];
        array[0] = srcref.getFirstLine() >= 0 ? srcref.getFirstLine() + 1 : Integer.MIN_VALUE;
        array[4] = srcref.getFirstColumn() >= 0 ? srcref.getFirstColumn() + 1 : Integer.MIN_VALUE;
        array[1] = Integer.MIN_VALUE;
        array[2] = srcref.getLastLine() >= 0 ? srcref.getLastLine() + 1 : Integer.MIN_VALUE;
        array[5] = srcref.getLastColumn() >= 0 ? srcref.getLastColumn() + 1 : Integer.MIN_VALUE;
        array[3] = Integer.MIN_VALUE;
        return array;
    }

    public static @Nullable IRSrcref createStatetSrcref(int @Nullable [] data) {
        if (data == null || data.length < 6) {
            return null;
        }
        return new RSrcref(data[0] > 0 ? data[0] - 1 : -1, data[4] > 0 ? data[4] - 1 : -1, data[2] > 0 ? data[2] - 1 : -1, data[5] > 0 ? data[5] : -1);
    }

    public static int getResumeEventDetail(byte op) {
        switch (op) {
            case 9: {
                return 32;
            }
            case 10: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 14: {
                return 4;
            }
        }
        return 0;
    }

    private RDbg() {
    }
}

