/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.renv;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.r.core.renv.RLibGroupWorkingCopy;
import org.eclipse.statet.rj.renv.core.BasicRLibGroup;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;

public abstract class REnvManagerLibGroup {
    public static String getLabel(String id) {
        if (id.equals("r.default")) {
            return Messages.REnvConfiguration_DefaultLib_label;
        }
        if (id.equals("r.site")) {
            return Messages.REnvConfiguration_SiteLibs_label;
        }
        if (id.equals("r.user")) {
            return Messages.REnvConfiguration_UserLibs_label;
        }
        if (id.equals("r.common")) {
            return Messages.REnvConfiguration_OtherLibs_label;
        }
        return null;
    }

    public static class Editable
    extends BasicRLibGroup
    implements RLibGroupWorkingCopy {
        private static List<RLibLocation> copy(List<? extends RLibLocation> locations) {
            return new ArrayList<RLibLocation>(locations);
        }

        public Editable(RLibGroup template) {
            super(template.getId(), template.getLabel(), Editable.copy(template.getLibLocations()));
        }

        public Editable(String id, String label) {
            super(id, label, new ArrayList());
        }

        @Override
        public List<RLibLocation> getLibLocations() {
            return super.getLibLocations();
        }

        @Override
        public RLibLocation newLibrary(String path) {
            return new BasicRLibLocation("user", path, null);
        }

        @Override
        public RLibLocation setLibrary(RLibLocation library, String directory) {
            List<RLibLocation> list = this.getLibLocations();
            int idx = list.indexOf(library);
            RLibLocation newLibrary = this.newLibrary(directory);
            list.set(idx, newLibrary);
            return newLibrary;
        }
    }

    public static class Final
    extends BasicRLibGroup {
        private static ImList<RLibLocation> copy(List<? extends RLibLocation> locations) {
            Object[] copies = new RLibLocation[locations.size()];
            int i = 0;
            while (i < copies.length) {
                copies[i] = new BasicRLibLocation(locations.get(i));
                ++i;
            }
            return ImCollections.newList((Object[])copies);
        }

        public Final(String id, String label, List<RLibLocation> libraries) {
            super(id, label, (List)ImCollections.toList(libraries));
        }

        public Final(RLibGroup template) {
            super(template.getId(), template.getLabel(), Final.copy(template.getLibLocations()));
        }
    }
}

