/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.r.core.renv.REnvManagerLibGroup;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.BasicRLibGroup;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPathsLoader;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class REnvLibGroups {
    private static String normalizePath(String path) {
        try {
            return new URI("file", null, path.charAt(0) == '/' ? path : String.valueOf('/') + path, null).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return path;
        }
    }

    private static RLibGroup newLibGroup(String id, List<RLibLocation> locations) {
        return new BasicRLibGroup(id, REnvManagerLibGroup.getLabel(id), locations);
    }

    static RuntimeRLibPathsLoader loadFromR(RService r, ProgressMonitor m) throws StatusException {
        try {
            Object[] libGroups = new RLibGroup[4];
            String rHome = REnvUtils.standardizePathString((String)RDataUtils.checkSingleCharValue((RObject)r.evalData("R.home()", m)));
            if (rHome == null) {
                throw new UnexpectedRDataException("null");
            }
            Pattern varPattern = Pattern.compile(r.getPlatform().getPathSep(), 16);
            HashSet<String> added = new HashSet<String>();
            String userVar = RDataUtils.checkSingleCharValue((RObject)r.evalData("Sys.getenv('R_LIBS_USER')", m));
            String[] paths = varPattern.split(userVar);
            ArrayList<Object> locations = new ArrayList<RLibLocation>(paths.length);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String pathString = stringArray[n2];
                if ((pathString = REnvUtils.standardizePathString((String)pathString)) != null) {
                    added.add(REnvLibGroups.normalizePath(pathString));
                    locations.add((RLibLocation)new BasicRLibLocation("r", pathString, null));
                }
                ++n2;
            }
            libGroups[1] = REnvLibGroups.newLibGroup("r.user", locations);
            RCharacterStore paths2 = (RCharacterStore)RDataUtils.checkRCharVector((RObject)r.evalData(".Library.site", m)).getData();
            int l = RDataUtils.checkIntLength((RStore)paths2);
            locations = new ArrayList(l);
            int i = 0;
            while (i < l) {
                String pathString = paths2.get(i);
                if ((pathString = REnvUtils.standardizePathString((String)pathString)) != null) {
                    added.add(REnvLibGroups.normalizePath(pathString));
                    locations.add((RLibLocation)new BasicRLibLocation("r", pathString, null));
                }
                ++i;
            }
            libGroups[2] = REnvLibGroups.newLibGroup("r.site", locations);
            paths2 = (RCharacterStore)RDataUtils.checkRCharVector((RObject)r.evalData(".Library", m)).getData();
            l = RDataUtils.checkIntLength((RStore)paths2);
            locations = new ArrayList(l);
            i = 0;
            while (i < l) {
                String pathString = paths2.get(i);
                if ((pathString = REnvUtils.standardizePathString((String)pathString)) != null) {
                    added.add(REnvLibGroups.normalizePath(pathString));
                    locations.add((RLibLocation)new BasicRLibLocation("r", pathString, null));
                }
                ++i;
            }
            libGroups[3] = REnvLibGroups.newLibGroup("r.default", locations);
            paths2 = (RCharacterStore)RDataUtils.checkRCharVector((RObject)r.evalData(".libPaths()", m)).getData();
            l = RDataUtils.checkIntLength((RStore)paths2);
            locations = new ArrayList(l);
            i = 0;
            while (i < l) {
                String pathString = paths2.get(i);
                if ((pathString = REnvUtils.standardizePathString((String)pathString)) != null && added.add(REnvLibGroups.normalizePath(pathString))) {
                    locations.add((RLibLocation)new BasicRLibLocation("r", pathString, null));
                }
                ++i;
            }
            libGroups[0] = REnvLibGroups.newLibGroup("r.common", locations);
            return new RuntimeRLibPathsLoader(rHome, (List)ImCollections.newList((Object[])libGroups));
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when detecting the R library path.", e));
        }
    }
}

